/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.jbi.serviceengine.core;

import javax.xml.namespace.QName;

/**
 * Class which holds the endpoint information specified in jbi.xml of the 
 * service unit.
 *
 * @author Vikas Awasthi
 */
public class DescriptorEndpointInfo {
    /**
     * Interface name.
     */
    QName interfacename;

    /**
     * Service name.
     */
    QName servicename;

    /**
     * Endpoint name.
     */
    String endpointname;

    /**
     * Provider endpoint.
     */
    boolean provider = false;
    boolean started = false;
    private String su_Name;

    public DescriptorEndpointInfo(String su_Name) {
        this.su_Name = su_Name;
    }

    /**
     * Sets the endpoint name.
     */
    public void setEndpointName(String epname) {
        endpointname = epname;
    }

    /**
     * Returns the endpoint name.
     */
    public String getEndpointName() {
        return endpointname;
    }

    /**
     * Sets the interface name.
     */
    public void setInterfaceName(QName intername) {
        interfacename = intername;
    }

    /**
     * Returns the interface name.
     */
    public QName getInterfaceName() {
        return interfacename;
    }

    /**
     * Sets the endpoint as provider.
     */
    public void setProvider() {
        provider = true;
    }

    /**
     * Returns true if the endpoint is provider.
     */
    public boolean isProvider() {
        return provider;
    }

    public boolean isStarted() {
        return started;
    }

    public void setStarted(boolean started) {
        this.started = started;
    }

    /**
     * Sets the service name.
     */
    public void setServiceName(QName sername) {
        servicename = sername;
    }

    /**
     * Returns the service name.
     */
    public QName getServiceName() {
        return servicename;
    }

    public String getKey() {
        return servicename.getLocalPart() + endpointname;
    }

    public String getSu_Name() {
        return su_Name;
    }
}
