/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.jbi.serviceengine.core;

import java.util.logging.Level;

/**
 * Represents JavaEEDeployer private MBean, responsible for
 * deploy/undeploy/start/stop of JavaEE application packaged inside the service assembly.
 *
 * @author bhavanishankar@dev.java.net
 */

public class JavaEEDeployer extends JavaEEServiceEngineSUManager
        implements JavaEEDeployerMBean {
    
    private String className = "JavaEEDeployer :: ";
    
    /**
     * Creates a new instance of JavaEEServiceEngineServiceUnitManager
     */
    public JavaEEDeployer() {
        super();
    }
    
    public void init(String saName, String suName, String suPath, String target)
    throws Exception {
        String methodSig = className + "init(String, String, String, String)";
        logger.log(Level.FINE,
                methodSig + " saName = " + saName + ", suName = " + suName +
                ". suPath = " + suPath + ", target = " + target);
    }
    
    public void shutDown(String saName, String suName, String target) throws
            Exception {
        String methodSig = className + "shutDown(String, String, String)";
        logger.log(Level.FINE,
                methodSig + " saName = " + saName + ", suName = " + suName +
                ", target = " + target);
    }
    
    public String deploy(String saName,
            String suName,
            String suPath,
            String target) throws Exception {
        String methodSig = className + "deploy(String, String, String, String)";
        logger.log(Level.FINE,
                methodSig + "saName = " + saName + ", suName = " + suName +
                ". suPath = " + suPath + ", target = " + target);
        
        return doDeploy(suName, suPath, target);
    }
    
    public String undeploy(String saName,
            String suName,
            String suPath,
            String target) throws Exception {
        String methodSig =
                className + "undeploy(String, String, String, String)";
        logger.log(Level.FINE,
                methodSig + " saName = " + saName + ", suName = " + suName +
                ". suPath = " + suPath + ", target = " + target);
        
        return doUnDeploy(suName, target);
    }
    
    public void start(String saName, String suName, String target) throws
            Exception {
        String methodSig = className + "start(String, String, String)";
        logger.log(Level.FINE,
                methodSig + " saName = " + saName + ", suName = " + suName +
                ", target = " + target);
        
        doStart(suName, target);
    }
    
    
    public void stop(String saName, String suName, String target) throws
            Exception {
        String methodSig = className + "stop(String, String, String)";
        logger.log(Level.FINE,
                methodSig + " saName = " + saName + ", suName = " + suName +
                ", target = " + target);
        
        doStop(suName, target);
    }
    
}
