/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.jbi.serviceengine.core;
import com.sun.enterprise.jbi.serviceengine.util.soap.EndpointMetaData;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.BundleDescriptor;

/**
 *
 * @author Manisha Umbarje
 */
public class ServiceEngineEndpoint {
    
    private Document wsdlDocument;
    private EndpointMetaData endpointMetaData;
    private ServiceEndpoint jbiEndpoint;
    private WebServiceEndpoint endpointDesc;
    private String url;
    private String sei;
    private String implClass;
    private boolean jaxwsFlag;
    private boolean ejbType;
    private boolean enabled ;
    private String contextRoot;
    private QName serviceName;
    private String endpointName;
    private String applicationName;
    private ClassLoader classLoader;

    /** Creates a new instance of Endpoint */
    public ServiceEngineEndpoint(WebServiceEndpoint endpointDesc,
                                 QName serviceName,
                                 String endpointName,
                                 String implClass,
                                 String contextRoot, 
                                 boolean enabled) {
        this.serviceName = serviceName;
        this.endpointName = endpointName;
        this.endpointDesc = endpointDesc;
        setApplicationName(endpointDesc);
        this.url = endpointDesc.getEndpointAddressUri();
        this.ejbType = endpointDesc.implementedByEjbComponent();
        this.sei = endpointDesc.getServiceEndpointInterface();
        this.implClass = implClass;
        this.jaxwsFlag = endpointDesc.getWebService().getMappingFileUri() == null;
        this.enabled = enabled;
        this.contextRoot = contextRoot;    
        this.classLoader = endpointDesc.getBundleDescriptor().getClassLoader();
    
    }
    
    public String getServiceEndpointInterface() {
        return sei;
    }
    
    public String getURI() {
        return url;
    }
    
    public boolean isImplementedByEJB() {
        return ejbType;
    }
    
    public String getImplementationClass() {
        return implClass; 
    }
    
    public String getContextRoot() {
        return contextRoot;
    }

    public ServiceEndpoint getServiceEndpoint() {
        return jbiEndpoint;
    }
    
    public void setServiceEndpoint(ServiceEndpoint jbiEp) {
        jbiEndpoint = jbiEp;
        setServiceName(jbiEp.getServiceName());
        setEndpointName(jbiEp.getEndpointName());
    }
    
    public QName getServiceName() {
        return serviceName;
    }
    
    public String getEndpointName() {
        return endpointName;
    }
    
    public boolean isEnabled() {
        return enabled;
    }
    
    public void setEnabled(boolean flag) {
        enabled = flag;
    }
    public boolean isJAXWSEndpoint() {
        return jaxwsFlag;
    }
    
    public ClassLoader getClassLoader() {
        return classLoader;
    }
    
    public WebServiceEndpoint getEndpointDesc() {
        return endpointDesc;
    }

    public Document getWsdlDocument() {
        return wsdlDocument;
    }

    public void setWsdlDocument(Document wsdlDocument) {
        this.wsdlDocument = wsdlDocument;
    }
    
    public EndpointMetaData getEndpointMetaData() {
        if(endpointMetaData == null)
            initializeEndpointMetaData();
        return endpointMetaData;
    }
    
    public void setEndpointMetaData(EndpointMetaData emd) {
        this.endpointMetaData = emd;
    }
    
    private void initializeEndpointMetaData() {
        try {
            endpointMetaData = new EndpointMetaData(readWSDLDefinition(), serviceName, endpointName);
            endpointMetaData.resolve();
        } catch(Exception ex) {
            ex.printStackTrace();
        }
    }
    
    private Definition readWSDLDefinition() throws Exception {
        WSDLFactory mFactory = WSDLFactory.newInstance();
        WSDLReader mReader = mFactory.newWSDLReader();
        return (wsdlDocument!=null)?
                mReader.readWSDL(wsdlDocument.getDocumentURI(), wsdlDocument):
                mReader.readWSDL(endpointDesc.getWebService().getGeneratedWsdlFilePath());
    }
    
    public String getApplicationName() {
        return applicationName;
    }

    private void setServiceName(QName svcName) {
        serviceName = svcName;
    }
    
    private void setEndpointName(String epName) {
        endpointName = epName;
    }

    /**
     * For standalone apps get the registration name and for ear applications 
     * use the archive Uri. 
     * e.g.: 
     * 1. For web-app.war, applicationName will be 'web-app'
     * 2. For enterprise-app.ear |__ ejb.jar
     *                           |__ web.war
     *  applicationName will be 'web.war'
     */
    private void setApplicationName(WebServiceEndpoint endpointDesc) {
        BundleDescriptor bundleDescriptor = endpointDesc.getBundleDescriptor();
        this.applicationName = 
                (bundleDescriptor.getModuleDescriptor().isStandalone())?
                        bundleDescriptor.getApplication().getRegistrationName():
                        bundleDescriptor.getModuleDescriptor().getArchiveUri();
    }
}
