/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.jbi.serviceengine.handlers;

import com.sun.enterprise.jbi.serviceengine.comm.MessageExchangeTransport;

/**
 * Handlers can be used to execute some logic just before messages are send or 
 * received in NMR.
 * 
 * @author Vikas Awasthi
 */
public interface JBIHandler {

    /**
     * Handles any logic to be performed before the normalized message is sent
     * to NMR. This will generally be called after message normalization happens.
     * @param meTransport
     */
    public void handleInbound(MessageExchangeTransport meTransport) throws Exception;

    /**
     * Handles any logic to be performed after the normalized message is read
     * from NMR. This will generally be called before message de-normalization 
     * happens.
     * @param meTransport
     */
    public void handleOutbound(MessageExchangeTransport meTransport) throws Exception;

}
