/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.jbi.serviceengine.handlers;

import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.jbi.serviceengine.comm.MessageExchangeTransport;

import javax.security.auth.Subject;
import javax.jbi.messaging.NormalizedMessage;

/**
 * This class handles the security context propagation during JBI message 
 * exchanges.
 * @author Vikas Awasthi
 */
public class JBISecurityHandler implements JBIHandler {

    public void handleInbound(MessageExchangeTransport meTransport) throws Exception {
        if(!isSecurityEnabled())
            return;

        Subject subject = SecurityContext.getCurrent().getSubject();
        NormalizedMessage msg = meTransport.getMessage();
        if(msg == null) return;

        msg.setProperty(SECURITY_PROPERTY, subject);
    }

    public void handleOutbound(MessageExchangeTransport meTransport) throws Exception {
        if(!isSecurityEnabled())
            return;

        NormalizedMessage msg = meTransport.getMessage();
        if(msg == null) return;

        Subject subject = (Subject)msg.getProperty(SECURITY_PROPERTY);
        if(subject != null) {
            SecurityContext sc = new SecurityContext(subject);
            SecurityContext.setCurrent(sc);
        }
    }

    /**
     * This method can be overridden to control the security propagation
     */
    protected boolean isSecurityEnabled() {
        return (sc_enable==null || sc_enable.equalsIgnoreCase("true"));
    }

    private final String SECURITY_PROPERTY = "javax.jbi.security.subject";
    private String sc_enable = System.getProperty("com.sun.enterprise.jbi.sc.enable");
}
