/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://open-esb.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * HEADER in each file and include the License file at
 * https://open-esb.dev.java.net/public/CDDLv1.0.html.
 * If applicable add the following below this CDDL HEADER,
 * with the fields enclosed by brackets "[]" replaced with
 * your own identifying information: Portions Copyright
 * [year] [name of copyright owner]
 */

/*
 * @(#)Util.java - ver 1.1 - 01/04/2006
 *
 * Copyright 2004-2006 Sun Microsystems, Inc. All Rights Reserved.
 */

package com.sun.enterprise.jbi.serviceengine.util;

import com.sun.enterprise.jbi.serviceengine.core.JavaEEServiceEngineContext;

import javax.jbi.component.ComponentContext;

/**
 * This utility class provides method to build management message.
 *
 * @author bhavanishankar@dev.java.net.
 * @see com.sun.enterprise.jbi.serviceengine.core.JavaEEServiceEngineSUManager
 */
public final class Util {
    /**
     * Creates a new instance of Util. The constructor has been declared private to
     * prevent instantiation.
     */
    private Util() {
    }

    /**
     * Helper method to build a management message for soap binding component.
     *
     * @param messageType component message holder type
     * @param taskName    task name
     * @param taskResult  task result indicating success or failure
     * @param locToken    token indicating the location of error.
     * @param locParam    parameters for error message.
     * @param locMessage  error message.
     * @param expObj      exceptino object
     * @return management message for the component.
     */
    public static String buildManagementMessage(String messageType,
                                                String taskName,
                                                String taskResult,
                                                String locToken,
                                                String locParam,
                                                String locMessage,
                                                Throwable expObj) {
        String componentName = JavaEEServiceEngineContext.getInstance()
                .getJBIContext()
                .getComponentName();
        ComponentMessageHolder messageHolder =
                new ComponentMessageHolder(messageType);
        messageHolder.setComponentName(componentName);
        messageHolder.setTaskName(taskName);
        messageHolder.setTaskResult(taskResult);

        if (locToken != null) {
            messageHolder.setLocToken(1, locToken);
        }

        if (locParam != null) {
            String[] locParams = new String[1];
            locParams[0] = locParam;
            messageHolder.setLocParam(1, locParams);
        }

        if (locMessage != null) {
            messageHolder.setLocMessage(1, locMessage);
        }

        if (expObj != null) {
            messageHolder.setExceptionObject(expObj);
        }

        String retMsg = null;

        try {
            ManagementMessageBuilder managementMessageBuilder =
                    new ManagementMessageBuilder();
            retMsg =
                    managementMessageBuilder.buildComponentMessage(messageHolder);
        }
        catch (Exception exp) {
            retMsg = null;
        }

        return retMsg;
    }
}
