/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/appserv-api/src/java/com/sun/appserv/management/base/LoggerSupport.java,v 1.1 2006/12/02 06:02:48 llc Exp $
 * $Revision: 1.1 $
 * $Date: 2006/12/02 06:02:48 $
 */

package com.sun.appserv.management.base;

import javax.management.ObjectName;


import java.util.logging.Logger;
import java.util.logging.LogManager;
import java.util.logging.Level;
import java.util.logging.Handler;
import java.util.logging.ConsoleHandler;



public final class LoggerSupport
{
	private LoggerSupport()	{}
	
	public static final String	AMX_LOGGER_PREFIX			= "javax.enterprise.system.tools.admin";
	public static final String	AMX_CLIENT_LOGGER_PREFIX	= AMX_LOGGER_PREFIX + ".client";
	public static final String	AMX_SERVER_LOGGER_PREFIX	= AMX_LOGGER_PREFIX + ".server";
	public static final String	AMX_MBEAN_LOGGER_PREFIX	= AMX_SERVER_LOGGER_PREFIX + ".mbeans";
	
	/**
		Name of the root logger for all AMX
	 */
	public static final String	AMX_ROOT_LOGGER			= AMX_LOGGER_PREFIX;
	
	/**
		Name of the root logger for AMX client code.
	 */
	public static final String	AMX_CLIENT_LOGGER			= AMX_CLIENT_LOGGER_PREFIX;
	
	/**
		Name of the root logger for all MBean loggers.
	 */
	public static final String	AMX_MBEAN_ROOT_LOGGER		= AMX_MBEAN_LOGGER_PREFIX;
	
	/**
		Name of the root logger for AMX server code
	 */
	public static final String	AMX_SERVER_LOGGER			= AMX_SERVER_LOGGER_PREFIX;
	
}
