/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.client;

import java.io.File;

import javax.net.ssl.X509TrustManager;
import javax.net.ssl.HandshakeCompletedListener;

/**
	Class encapsulating parameters available for use with TLS.
	
	@see com.sun.appserv.management.client.TrustStoreTrustManager
	@see com.sun.appserv.management.client.TrustAnyTrustManager
	@see com.sun.appserv.management.client.HandshakeCompletedListenerImpl
 */
public final class TLSParams
{
	private final X509TrustManager[]	mTrustManagers;
	private final HandshakeCompletedListener	mHandshakeCompletedListener;

    /**
        Return a X509TrustManager[] supporting trust via
        the specified trustStore file using the specified password.
        
        @param trustStore
        @param trustStorePassword password to use for the trustStore file
        @param prompt whether to prompt via System.out/in for addition of new certificates
     */
		public static X509TrustManager[]
	getTrustManagers(
		final File 		trustStore,
		final char[]	trustStorePassword,
		final boolean	prompt )
	{
		final TrustStoreTrustManager	mgr	=
			new TrustStoreTrustManager( trustStore, trustStorePassword );
		mgr.setPrompt( prompt );
			
		final X509TrustManager[]	trustMgrs	= new X509TrustManager[] { mgr };
		
		return( trustMgrs );
	}
	
	/**
		@param trustStore
		@param trustStorePassword
		@param prompt
		@param handshakeCompletedListener (may be null)
	 */
		public
	TLSParams(
		final File 		trustStore,
		final char[]	trustStorePassword,
		final boolean	prompt,
		final HandshakeCompletedListener	handshakeCompletedListener )
	{
		this(  getTrustManagers( trustStore, trustStorePassword, prompt), handshakeCompletedListener );
		
	}
	
	/**
		@param trustManagers
		@param handshakeCompletedListener (may be null)
	 */
		public
	TLSParams(
		final X509TrustManager[]			trustManagers,
		final HandshakeCompletedListener	handshakeCompletedListener )
	{
		if ( trustManagers == null )
		{
			throw new IllegalArgumentException();
		}
		
    	mTrustManagers		= trustManagers;
    	mHandshakeCompletedListener	= handshakeCompletedListener;
	}
	
	/**
		@param trustManager
		@param handshakeCompletedListener (may be null)
	 */
		public
	TLSParams(
		final X509TrustManager				trustManager,
		final HandshakeCompletedListener	handshakeCompletedListener )
	{
		this( new X509TrustManager[] { trustManager }, handshakeCompletedListener );
	}
	
	/**
	    @return the TrustManagers in use
	 */
     	public X509TrustManager[]
    getTrustManagers( )
    {
    	return( mTrustManagers );
    }
    
	/**
	    @return the HandshakeCompletedListener in use or null if none
	 */
    	public HandshakeCompletedListener
    getHandshakeCompletedListener( )
    {
    	return( mHandshakeCompletedListener );
    }
}
