/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/appserv-api/src/java/com/sun/appserv/management/config/ConfigConfigKeys.java,v 1.1 2006/12/02 06:03:01 llc Exp $
 * $Revision: 1.1 $
 * $Date: 2006/12/02 06:03:01 $
 */


package com.sun.appserv.management.config;



/**
	Keys for use with {@link DomainConfig#createConfigConfig}.
 */
public final class ConfigConfigKeys
{
	private ConfigConfigKeys()	{}
	
	/**
		Key for use with {@link DomainConfig#createConfigConfig},
		value must be {@link java.lang.Boolean}.
	 */
	public static final String DYNAMIC_RECONFIGURATION_ENABLED_KEY = "DynamicReconfigurationEnabled";
	
	/**
		Key for use with {@link DomainConfig#createConfigConfig}. Specifies
		the name of the config which should be *copied*.  Default is
		{@link #DEFAULT_SRC_CONFIG_NAME}.
	 */
	public static final String SRC_CONFIG_NAME_KEY = "SrcConfigKey";
	
	/**
		Default config which will be copied by
		{@link DomainConfig#createConfigConfig}.
		@see #SRC_CONFIG_NAME_KEY
	 */
	public static final String DEFAULT_SRC_CONFIG_NAME = "default-config";
}
