/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/appserv-api/src/java/com/sun/appserv/management/config/HealthCheckerConfig.java,v 1.1 2006/12/02 06:03:08 llc Exp $
 * $Revision: 1.1 $
 * $Date: 2006/12/02 06:03:08 $
 */
 
package com.sun.appserv.management.config;

import com.sun.appserv.management.base.XTypes;

/**
  <b>EE only</b>
  Each cluster would be configured for a ping based health check mechanism.
  Base interface for such a Health Checker.
*/
public interface HealthCheckerConfig extends AMXConfig {
    /** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
    public static final String	J2EE_TYPE	= XTypes.HEALTH_CHECKER_CONFIG;

    /**
        Returns the relative URL to ping to determine the health state of a
        listener.
     */
    public String getURL();

    /**
        Sets the relative URL to ping to determine the health state of a
        listener.
     */
    public void setURL(String url);

    /**
        Returns interval, in seconds, between health checks. A value of "0"
        means that the health check is disabled. 
     */
    public String getIntervalInSeconds();

    /**
        Set the interval, in seconds, between health checks. A value of "0"
        means that the health check will be disabled. Default is 30
        seconds. Must be 0 or greater.
     */
    public void setIntervalInSeconds(String intervalInSeconds);

    /**
        Return the maximum time, in seconds, that a server must respond to a
        health check request to be considered healthy. 
     */
    public String getTimeoutInSeconds();

    /**
        Set the maximum time, in seconds, that a server must respond to a
        health check request to be considered healthy. Default is 10
        seconds. Must be greater than 0.
     */
    public void setTimeoutInSeconds(String timeoutInSeconds);
}
