/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/appserv-api/src/java/com/sun/appserv/management/config/LogServiceConfig.java,v 1.1 2006/12/02 06:03:14 llc Exp $
 * $Revision: 1.1 $
 * $Date: 2006/12/02 06:03:14 $
 */


package com.sun.appserv.management.config;

import com.sun.appserv.management.base.XTypes;



import java.util.Map;


import com.sun.appserv.management.base.Container;

/**
	Configuration for the &lt;log-service&gt; element.
	 
	@see ModuleLogLevelsConfigKeys
 */
public interface LogServiceConfig
	extends PropertiesAccess, Container, ConfigElement
{
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
	public static final String	J2EE_TYPE			= XTypes.LOG_SERVICE_CONFIG;
	

	public boolean	getAlarms();
	public void	setAlarms( boolean value );

	public String	getFile();
	public void	setFile( String value );

	public String	getLogFilter();
	public void	setLogFilter( String value );

	public String	getLogHandler();
	public void	setLogHandler( String value );

    /**
        @since AppServer 9.0
     */
	public String	getLogRotationTimeLimitInMinutes();
	public void	setLogRotationTimeLimitInMinutes( String value );
	
	public String	getLogRotationLimitInBytes();
	public void	setLogRotationLimitInBytes( String value );

	public boolean	getLogToConsole();
	public void	setLogToConsole( boolean value );

	public boolean	getUseSystemLogging();
	public void	setUseSystemLogging( boolean value );
	
	
	public String  getRetainErrorStatisticsForHours();
	public void    setRetainErrorStatisticsForHours( String hours );
	
// -------------------- Operations --------------------
	/**
		Creates new module-log-levels element.

		@param params Map of optional attributes whose keys are defined in
		ModuleLogLevelsParams class.
		@return A proxy to the ModuleLogLevelsConfig MBean.
		@see ModuleLogLevelsConfigKeys
	 */
	public ModuleLogLevelsConfig	createModuleLogLevelsConfig( Map<String,String> params );

	/**
		Removes module-log-levels element.
	 */
	public void			removeModuleLogLevelsConfig();

	/**
		Get the ModuleLogLevelsConfig MBean.
	 */
	public ModuleLogLevelsConfig getModuleLogLevelsConfig();
}
