/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/appserv-api/src/java/com/sun/appserv/management/config/SSLConfig.java,v 1.1 2006/12/02 06:03:22 llc Exp $
 * $Revision: 1.1 $
 * $Date: 2006/12/02 06:03:22 $
 */

package com.sun.appserv.management.config;

import com.sun.appserv.management.base.XTypes;

/**
	Base interface Configuration for an &lt;ssl&gt; element.
*/
public interface SSLConfig extends ConfigElement 
{
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
	public static final String	J2EE_TYPE	= XTypes.SSL_CONFIG;
	
	public String	getCertNickname();
	public void	setCertNickname( String value );

	public boolean	getClientAuthEnabled();
	public void	setClientAuthEnabled( boolean value );

	public String	getSSL2Ciphers();
	public void	setSSL2Ciphers( String value );

	public boolean	getSSL2Enabled();
	public void	setSSL2Enabled( boolean value );

	public boolean	getSSL3Enabled();
	public void	setSSL3Enabled( boolean value );

	public String	getSSL3TLSCiphers();
	public void	setSSL3TLSCiphers( String value );

	public boolean	getTLSEnabled();
	public void	setTLSEnabled( boolean value );

	public boolean	getTLSRollbackEnabled();
	public void	setTLSRollbackEnabled( boolean value );

}