/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/appserv-api/src/java/com/sun/appserv/management/config/ServerRefConfig.java,v 1.1 2006/12/02 06:03:23 llc Exp $
 * $Revision: 1.1 $
 * $Date: 2006/12/02 06:03:23 $
 */

package com.sun.appserv.management.config;

import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.Container;

/**
 * represents the &lt;server-ref&gt; element.
*/
public interface ServerRefConfig extends RefConfig, HealthCheckerConfigCR, Container
{
    /** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
    public static final String	J2EE_TYPE	= XTypes.SERVER_REF_CONFIG;

    /**
        returns the time, in minutes, that it takes this application to reach
        a quiescent state after having been disabled
     */        
    public int getDisableTimeoutInMinutes();

    /**
        Set the time, in minutes, that it takes this application to reach
        a quiescent state after having been disabled
     */        
    public void setDisableTimeoutInMinutes(final int timeoutInMins);

    /**
        <b>EE only</b>
        Return the boolean flag that causes any and all load-balancers using
        this application to consider this application unavailable to
        them. Defaults to unavailable (false).
     */    
    public boolean getLBEnabled();

    /**
        <b>EE only</b>
        Set the boolean flag that causes any and all load-balancers using
        this application to consider this application unavailable to
        them. 
     */    
     public void setLBEnabled(final boolean lbEnabled);        
}