/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/appserv-api/src/java/com/sun/appserv/management/config/SessionManagerConfig.java,v 1.1 2006/12/02 06:03:24 llc Exp $
 * $Revision: 1.1 $
 * $Date: 2006/12/02 06:03:24 $
 */


package com.sun.appserv.management.config;

import java.util.Map;

import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.Container;



/**
	 Configuration for the &lt;session-manager&gt; element.
 */
public interface SessionManagerConfig
	extends ConfigElement, Container
{
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
	public static final String	J2EE_TYPE	= XTypes.SESSION_MANAGER_CONFIG;

	/**
		Creates new manager-properties element.
	 
		@param params Map of optional attributes whose keys are defined in
		ManagerPropertiesParams interface.
		@return A proxy to the ManagerPropertiesConfig MBean.
		@see ManagerPropertiesConfigKeys
	 */
	public ManagerPropertiesConfig createManagerPropertiesConfig( Map<String,String> params );

	/**
		Removes manager-properties element.
	 */
	public void removeManagerPropertiesConfig();

	/**
		Get the ManagerPropertiesConfig MBean.
	 */
	public ManagerPropertiesConfig getManagerPropertiesConfig();

	/**
		Creates new manager-properties element.
	 
		@param params Map of optional attributes whose keys are defined in
		ManagerPropertiesParams interface.
		@return A proxy to the StorePropertiesConfig MBean.
		@see StorePropertiesConfigKeys
	 */
	public StorePropertiesConfig createStorePropertiesConfig( Map<String,String> params );

	/**
		Removes store-properties element.
	 */
	public void removeStorePropertiesConfig();

	/**
		Get the StorePropertiesConfig MBean.
	 */
	public StorePropertiesConfig getStorePropertiesConfig();
}
