/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/appserv-api/src/java/com/sun/appserv/management/config/VirtualServerConfigKeys.java,v 1.1 2006/12/02 06:03:27 llc Exp $
 * $Revision: 1.1 $
 * $Date: 2006/12/02 06:03:27 $
 */


package com.sun.appserv.management.config;

/**
	Keys for use with {@link HTTPServiceConfig#createVirtualServerConfig}.
 */
public interface VirtualServerConfigKeys
{
	/** comma-separated list of http-listeners */
	public final static String	HTTP_LISTENERS_KEY		= "HTTPListeners";
	public final static String	DEFAULT_WEB_MODULE_KEY	= "DefaultWebModule";
	public final static String	LOG_FILE_KEY			= "LogFile";
	public final static String	DOC_ROOT_KEY			= "Docroot";

	public static final String	DOC_ROOT_PROPERTY_KEY	= PropertiesAccess.PROPERTY_PREFIX + "docroot";
	public static final String	ACCESS_LOG_PROPERTY_KEY = PropertiesAccess.PROPERTY_PREFIX + "accesslog";
	
	
	/**
		Possible values:
		<ul>
		<li>{@link #STATE_DISABLED}</li>
		<li>{@link #STATE_OFF}</li>
		<li>{@link #STATE_ON}</li>
		</ul>
	*/
	public final static String	STATE_KEY				= "State";
	
	/** One possible value for {@link #STATE_KEY} */
	public static final String	STATE_DISABLED	= "disabled";
	/** One possible value for {@link #STATE_KEY} */
	public static final String	STATE_OFF	= "off";
	/** One possible value for {@link #STATE_KEY} */
	public static final String	STATE_ON	= "on";
}
