/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/appserv-api/src/java/com/sun/appserv/management/ext/lb/LoadBalancer.java,v 1.1 2006/12/02 06:03:30 llc Exp $
 * $Revision: 1.1 $
 * $Date: 2006/12/02 06:03:30 $
 */

package com.sun.appserv.management.ext.lb;

import java.util.Date;

import static com.sun.appserv.management.base.XTypes.*;
import com.sun.appserv.management.base.AMX;

/**
   Runtime counterpart for the config MBean {@link com.sun.appserv.management.config.LoadBalancerConfig} 
   representing the load-balancer element.
 */
public interface LoadBalancer extends AMX {

    /** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
    public static final String	J2EE_TYPE = LOAD_BALANCER;

    /**
      Applies changes in the corresponding configuration to this LB 
     */
    public void applyLBChanges();        

    /**
      @return true if there are pending changes for this LB
     */
    public boolean isApplyChangeRequired();       

    /**
      Exports the corresponding LBConfig information and returns the contents as a string.
      @see com.sun.appserv.management.config.LBConfig
     */
    public String getLoadBalancerXML();    
      
    /**
      Returns the timestamp of the most recent export of corresponding LBConfig
     */
    public Date getLastExported();        
    
    /**
      Returns the timestamp of the most recent application of corresponding LBConfig
     */
    public Date getLastApplied();            

    /**
      Returns the timestamp of the last time the stats on this loadbalancer were reset
     */
    public Date getLastResetTime();            

    /**
      Reset the monitoring stats on this loadbalancer.
     */
    public void resetStats();
    
    /**
      Reset the monitoring stats on this loadbalancer.
     */
    public boolean testConnection();
            
    /**
     * Returns the uhealthy/healthy/quiesced status for an insatnce load balanced
     * by this load balancer.
     */
    public String getStatus(String instanceName);     
}
