/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.helper;

import java.util.Map;

import javax.management.ObjectName;
import javax.management.Attribute;
import javax.management.AttributeList;

import com.sun.appserv.management.base.AMXDebug;
import com.sun.appserv.management.util.misc.Output;
import com.sun.appserv.management.util.misc.StringUtil;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.MapUtil;


/**
	Convenient wrapper around {@link AMXDebug}.
    Can be made non-final if necessary; declared as 'final' until needed.
    Note that the "-DAMX-DEBUG=true" must be set in order to see any output.
 */
public final class AMXDebugHelper
{
    private final Output        mOutput;
    private final String        mName;
    volatile boolean            mEchoToStdOut;
    
        public
    AMXDebugHelper( final String name )
    {
        mOutput  = AMXDebug.getInstance().getOutput( name );
        mName   = name;
        
        mEchoToStdOut   = false;
    }
    
        public
    AMXDebugHelper( )
    {
        this( "debug" );
    }
    
        public boolean
    getEchoToStdOut( final boolean echo )
    {
        return mEchoToStdOut;
    }
    
        public void
    setEchoToStdOut( final boolean echo )
    {
        mEchoToStdOut   = echo;
    }
  
        public boolean
    getDebug()
    {
        return AMXDebug.getInstance().getDebug( mName );
    }
        public void
    setDebug( final boolean debug )
    {
        AMXDebug.getInstance().setDebug( mName, debug );
    }
      
        private void
    printlnWithTime( final String s )
    {
         final long now  = System.currentTimeMillis();
         final String msg   = now + ": " + s;
         
         mOutput.println( msg );
         if ( mEchoToStdOut )
         {
            System.out.println( msg );
         }
    }
    
        public void
    println( final Object o )
    {
        if ( getDebug() )
        {
            printlnWithTime( "" + StringUtil.toString(o) );
        }
    }
    
        public void
    println()
    {
        println( "" );
    }
    
      
    /**
        This form is preferred for multiple arguments so that String concatenation
        can be avoided when no message will actually be output. For example, use:
        <pre>println( a, b, c)</pre>
        instead of:
        <pre>println( a + b + c )</pre>
     */
        public void
    println( final Object... items )
    {
        if ( getDebug() && items != null )
        {
            String msg  = null;
            
            if ( items.length == 1 )
            {
                msg = StringUtil.toString( items[0] );
            }
            else
            {
                msg = StringUtil.toString( "", (Object[])items );
            }
            printlnWithTime( msg );
        }
    }
    
        public void
    dumpStack( final String msg )
    {
        if ( getDebug() )
        {
            println();
            println( "STACK DUMP FOLLOWS: " + msg);
            println( StringUtil.toString( new Exception( "not a real exception" ) ) );
            println();
        }
    }
}




