/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/appserv-api/src/java/com/sun/appserv/management/j2ee/statistics/BoundedRangeStatisticImpl.java,v 1.2 2006/12/08 20:50:14 llc Exp $
 * $Revision: 1.2 $
 * $Date: 2006/12/08 20:50:14 $
 */

package com.sun.appserv.management.j2ee.statistics;

import java.util.Map;
import java.io.Serializable;

import javax.management.openmbean.CompositeData;
import javax.management.j2ee.statistics.BoundedRangeStatistic;

import com.sun.appserv.management.util.jmx.OpenMBeanUtil;

/**
	Serializable implementation of a BoundedRangeStatistic
 */
public class BoundedRangeStatisticImpl extends RangeStatisticImpl
	implements BoundedRangeStatistic, Serializable
{
	static final long serialVersionUID = 4803476800834526575L;
	
	private long	LowerBound;
	private long	UpperBound;
	
	
		public
	BoundedRangeStatisticImpl(
		final String	name,
		final String	description,
		final String	unit,
		final long		startTime,
		final long		lastSampleTime,
		final long		low,
		final long		current,
		final long		high,
		final long		lowerBound,
		final long		upperBound )
	{
		super( name, description, unit, startTime, lastSampleTime, low, current, high );
		
		if ( lowerBound > upperBound )
		{
			throw new IllegalArgumentException();
		}
		
		this.LowerBound	= lowerBound;
		this.UpperBound	= upperBound;
	}
	
		public
	BoundedRangeStatisticImpl( final CompositeData compositeData )
	{
		this( OpenMBeanUtil.compositeDataToMap( compositeData ) );
	}
	
		public
	BoundedRangeStatisticImpl( final Map<String,?> m )
	{
		this( new MapStatisticImpl( m ) );
	}
	
		public
	BoundedRangeStatisticImpl( final MapStatistic s )
	{
		super( s );
		
		LowerBound	= s.getlong( "LowerBound" );
		UpperBound	= s.getlong( "UpperBound" );
	}
	
		public
	BoundedRangeStatisticImpl( final BoundedRangeStatistic s )
	{
		super( s );
		
		LowerBound	= s.getLowerBound();
		UpperBound	= s.getUpperBound();
	}
	
		public long
	getLowerBound()
	{
		return( LowerBound );
	}
	
		public long
	getUpperBound()
	{
		return( UpperBound );
	}
}





