/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/appserv-api/src/java/com/sun/appserv/management/j2ee/statistics/CountStatisticImpl.java,v 1.1 2006/12/02 06:03:46 llc Exp $
 * $Revision: 1.1 $
 * $Date: 2006/12/02 06:03:46 $
 */

package com.sun.appserv.management.j2ee.statistics;

import java.util.Map;
import java.io.Serializable;

import javax.management.openmbean.CompositeData;

import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.CountStatistic;

import com.sun.appserv.management.util.jmx.OpenMBeanUtil;
import com.sun.appserv.management.util.misc.ObjectUtil;


/**
	
 */
public class CountStatisticImpl extends StatisticImpl
	implements CountStatistic, Serializable
{
	static final long serialVersionUID = -4868791714488583778L;
	
	/* member name as defined by JSR 77 */
	private final long	Count;
	
		public
	CountStatisticImpl(
		final String	name,
		final String	description,
		final String	unit,
		final long		startTime,
		final long		lastSampleTime,
		final long		count )
	{
		super( name, description, unit, startTime, lastSampleTime );
		Count	= count;
	}
	
		public
	CountStatisticImpl( final CompositeData compositeData )
	{
		this( OpenMBeanUtil.compositeDataToMap( compositeData ) );
	}
	
		public
	CountStatisticImpl( final CountStatistic s )
	{
		super( s );
		Count	= s.getCount();
	}
	
		public
	CountStatisticImpl( final MapStatistic s )
	{
		super( s );
		Count	= s.getlong( "Count" );
	}
	
		public
	CountStatisticImpl( final Map<String,?> data )
	{
		this( new MapStatisticImpl( data ) );
	}


 		public long
 	getCount()
 	{
 		return( Count );
 	}
 	
 	    public int
 	hashCode()
 	{
 	    return super.hashCode() ^ ObjectUtil.hashCode( Count );
 	}
 	
 	
		public boolean
	equals( final Object rhs )
	{
		boolean	equals	= super.equals( rhs ) && (rhs instanceof CountStatistic);
		
		if ( equals )
		{
			final CountStatistic	s	= (CountStatistic)rhs;
			
			equals	= getCount() == s.getCount();
		}
		return( equals );
	}
}





