/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/appserv-api/src/java/com/sun/appserv/management/j2ee/statistics/GetterInvocationHandler.java,v 1.1 2006/12/02 06:03:46 llc Exp $
 * $Revision: 1.1 $
 * $Date: 2006/12/02 06:03:46 $
 */

package com.sun.appserv.management.j2ee.statistics;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.StringUtil;

/**
	Abstract base {@link InvocationHandler} for any getXXX() method.
	<br><b>Internal use only</b>
 */
public abstract class GetterInvocationHandler<T> implements InvocationHandler,Serializable
{
	static final long serialVersionUID = 7293181901362984709L;

	/**
	 */
		public
	GetterInvocationHandler()
	{
	}
	
	protected abstract T	    getValue( String name );
	protected abstract boolean	containsValue( String name );
	
	/**
	*/
		public Object
	invoke(
		Object		myProxy,
    	Method		method,
		Object[]	args )
   		throws java.lang.Throwable
   	{
   		Object			result	= null;
   		final String	methodName		= method.getName();
   		final int		numArgs	= args == null ? 0 : args.length;
   		
   		if ( numArgs == 0 && JMXUtil.isGetter( method ) )
   		{
   			final String	name	= StringUtil.stripPrefix( methodName, JMXUtil.GET );
   			
   			result	= getValue( name );
   			if ( result == null && ! containsValue( name ) )
   			{
   				throw new NoSuchMethodException( methodName );
   			}
   		}
   		else if ( method.getName().equals( "equals" ) &&
   			numArgs == 1 )
   		{
   			result	= new Boolean( equals( args[ 0 ] ) );
   		}
   		else if ( numArgs == 0 && method.getName().equals( "toString" ) &&
   			method.getReturnType() == String.class )
   		{
   			result	= this.toString();
   		}
   		else if ( numArgs == 0 && method.getName().equals( "hashCode" ) &&
   			method.getReturnType() == int.class )
   		{
   			result	= new Integer( this.hashCode() );
   		}
   		else
   		{
   			throw new IllegalArgumentException( methodName );
   		}

   		return( result );
   	}
   
}





