/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 */

package com.sun.appserv.management.monitor;

import java.util.Map;

import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.Container;

import com.sun.appserv.management.monitor.statistics.WebModuleVirtualServerStats;

/**
	Monitoring peer for {@link com.sun.appserv.management.j2ee.WebModule}.
	For available Statistics, see {@link WebModuleVirtualServerStats}.
 */
public interface WebModuleVirtualServerMonitor extends MonitoringStats, Container
{
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
	public static final String	J2EE_TYPE	= XTypes.WEB_MODULE_VIRTUAL_SERVER_MONITOR;
	
	/**
	    <b>Enterprise Edition only; not supported in PE/Glassfish.</b>
		@return WebModuleVirtualServerStats
	 */
	public WebModuleVirtualServerStats getWebModuleVirtualServerStats();
	
	/**
		@return Map of {@link ServletMonitor}, keyed by name
	 */
	public Map<String,ServletMonitor>	getServletMonitorMap( );
	
	/**
		@return Map of {@link WebServiceEndpointMonitor}, keyed by name
	 */
	public Map<String,WebServiceEndpointMonitor>	getWebServiceEndpointMonitorMap( );
}
