/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/appserv-api/src/java/com/sun/appserv/management/util/misc/MethodComparator.java,v 1.1 2006/12/02 06:04:30 llc Exp $
 * $Revision: 1.1 $
 * $Date: 2006/12/02 06:04:30 $
 */
 

package com.sun.appserv.management.util.misc;

import java.lang.reflect.Method;

/**
	Caution: this Comparator may be inconsistent with equals() because it ignores the description.
 */
public final class MethodComparator implements java.util.Comparator<Method>
{
	public static final MethodComparator	INSTANCE	= new MethodComparator();
	
	private	MethodComparator()	{}
	
		public int
	compare( Method m1, Method m2 )
	{
		int	result	= m1.getName().compareTo( m2.getName() );
		if ( result == 0 )
		{
			result	= m1.toString().compareTo( m2.toString() );
		}
		
		return( result );
	}
	
		public boolean
	equals( Object other )
	{
		return( other instanceof MethodComparator );
	}
}
	
	



