/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.util.misc;

import java.util.Map;
import java.util.HashMap;
import java.util.List;
import java.util.ArrayList;
import java.util.Collections;

import com.sun.appserv.management.util.misc.MapUtil;


//import com.sun.appserv.management.helper.AMXDebugHelper;

/**
    Central registry of timing values. 
 */
public final class Timings
{
    static private final Timings INSTANCE = new Timings( "default" );
    static private final Map<String,Timings>  sInstances  = new HashMap<String,Timings>();
    
    private final List<String>    mCheckpointNames;
    private final List<Long>      mCheckpointTimes;
    
    private final String              mName;
    
    static private final String NEWLINE = "\n";
    
    /**
        Get the default Timings object. No synchronization happens or is needed; fast.
     */
        public static Timings
    getInstance()
    {
        return INSTANCE;
    }
    
    /**
        Get a named Timings object. Synchronization happens in this call, to access a Map.
     */
       public static Timings
    getInstance( final String name )
    {
        Timings   timings   = null;
        synchronized( sInstances )
        {
            timings = sInstances.get( name );
            if ( timings == null )
            {
                timings = new Timings( name );
                sInstances.put( name, timings );
            }
        }
        return timings;
    }
    
        public static void
    removeInstance( final String name )
    {   
        synchronized( sInstances )
        {
            sInstances.remove( name );
        }
    }
    
        public
    Timings( final String name )
    {
        mName   = name;
        mCheckpointNames    = new ArrayList<String>();
        mCheckpointTimes    = new ArrayList<Long>();
    }
    
        public String
    getName()
    {
        return mName;
    }
    
    /**
        @param checkpoint the name of the checkpoint
        @param nanoseconds the nanoseconds ascribed to this checkpoint
     */
        public void
    add( final String checkpointName, final long nanoseconds )
    {
        synchronized( mCheckpointNames )
        {
            mCheckpointNames.add( checkpointName );
            mCheckpointTimes.add( nanoseconds );
        }
    }
    
    /**
        Convenience--same as <code>add( checkpoint, delta.elapsed() )</code>;
        @param checkpoint the name of the checkpoint
        @param delta a TimingDelta
     */
        public void
    add( final String checkpointName, final TimingDelta delta )
    {
        add( checkpointName, delta.elapsed() );
    }
    
        public String
    toString()
    {
        String s = "Timing Log " + StringUtil.quote( getName() ) + NEWLINE;
        synchronized( mCheckpointNames )
        {
            for( int i = 0; i < mCheckpointNames.size(); ++i )
            {
                final String item = mCheckpointNames.get(i) + " = " +
                    StringUtil.getTimingString( mCheckpointTimes.get(i) );
                    
                s   = s + item + NEWLINE;
            }
        }
        return s;
    }
}

































