/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/appserv-api/src/java/com/sun/appserv/management/util/misc/TokenizerParams.java,v 1.1 2006/12/02 06:04:35 llc Exp $
 * $Revision: 1.1 $
 * $Date: 2006/12/02 06:04:35 $
 */
 
package com.sun.appserv.management.util.misc;


/**
	Parameters that TokenizerImpl accepts.
 */
public class TokenizerParams
{
	/**
		Delimiters are characters that separate tokens.
	 */
	public String		mDelimiters;
	
	/**
		When multiple delimiters abut each other, are they all treated as
		a single delimiter, or as multiples with implied empty tokens
		between them?
	 */
	public boolean		mMultipleDelimsCountAsOne;
	
	/**
		The escape char, allowed to be anything, but typically should
		be BACKSLASH.
	 */
	public char			mEscapeChar;
	
	/**
		Characters which may be escaped over and above the standard ones.
	 */
	public String		mEscapableChars;
	
	/**
		When an invalid escape sequence is encountered, either an exception
		may be thrown, or the sequence may be emitted literally.
	 */
	public boolean		mEmitInvalidEscapeSequencesLiterally;
	
	public final static char	BACKSLASH	= '\\';
	public final static char	COMMA	= ',';
	public final static char	DEFAULT_ESCAPE_CHAR	= BACKSLASH;
	public final static String	DEFAULT_DELIMITERS	= "" + COMMA;
	
		public
	TokenizerParams()
	{
		mDelimiters					= DEFAULT_DELIMITERS;
		mMultipleDelimsCountAsOne	= true;
		mEscapeChar					= DEFAULT_ESCAPE_CHAR;
		mEscapableChars				= "" + DEFAULT_ESCAPE_CHAR;
		mEmitInvalidEscapeSequencesLiterally	= false;
	}
	
		public void
	ensureDelimitersEscapable()
	{
		for( int i = 0; i < mDelimiters.length(); ++i )
		{
			final char	delim	= mDelimiters.charAt( i );
			
			if ( mEscapableChars.indexOf( delim ) < 0 )
			{
				mEscapableChars	= mEscapableChars + delim;
			}
		}
	}
}

