
/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/appserv-api/src/java/com/sun/appserv/management/util/stringifier/ArrayStringifier.java,v 1.1 2006/12/02 06:04:35 llc Exp $
 * $Revision: 1.1 $
 * $Date: 2006/12/02 06:04:35 $
 */
 
package com.sun.appserv.management.util.stringifier;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;

/**
	Stringifies an array, using an optional array element Stringifier
 */
 
public final class ArrayStringifier implements Stringifier
{
	final String			mDelim;
	final Stringifier		mElementStringifier;
	boolean					mAddBraces;
	
	static final char	LEFT_BRACE	= '{';
	static final char	RIGHT_BRACE	= '}';
	static final String	DEFAULT_DELIM=",";
	
		public 
	ArrayStringifier()
	{
		this( SmartStringifier.DEFAULT );
		mAddBraces	= false;
	}
		public 
	ArrayStringifier( boolean addBraces )
	{
		this( DEFAULT_DELIM, SmartStringifier.DEFAULT, addBraces );
	}
	
		public
	ArrayStringifier( String delim )
	{
		this( delim, false );
	}
	
		public
	ArrayStringifier( String delim, boolean addBraces)
	{
		this( delim, SmartStringifier.DEFAULT, addBraces );
	}
	
		public
	ArrayStringifier( Stringifier elementStringifier )
	{
		this( DEFAULT_DELIM, elementStringifier );
	}
	
		public
	ArrayStringifier( String delim, Stringifier elementStringifier )
	{
		this( delim, elementStringifier, false );
	}
	
		public
	ArrayStringifier( String delim, Stringifier elementStringifier, boolean addBraces)
	{
		mDelim				= delim;
		mElementStringifier	= elementStringifier;
		mAddBraces			= addBraces;
	}
	
		static String
	addBraces( boolean add, String s )
	{
		String	out	= s;
		if ( add )
		{
			out	= LEFT_BRACE + s + RIGHT_BRACE;
		}
		return( out );
	}
	
		public String
	stringify( Object o )
	{
		final String	s	= this.stringify( (Object [])o, mDelim, mElementStringifier );
		
		return( addBraces( mAddBraces, s ) );
	}
	
	/**
		Static variant when direct call will suffice.
	 */
		public static String
	stringify( Object [] o, String delim, Stringifier stringifier )
	{
		final Iterator	iter		= Arrays.asList( o ).iterator();
		final IteratorStringifier	iterStringifier	= new IteratorStringifier( delim, stringifier );
		
		final String	s	= iterStringifier.stringify( iter );
		return( s );
	}
	
	/**
		Static variant when direct call will suffice.
	 */
		public static String
	stringify( Object [] o, String delim )
	{
		return( stringify( o, delim, SmartStringifier.DEFAULT ) );
	}
	
	public final static ArrayStringifier DEFAULT = new ArrayStringifier( "," );
}

