/*
 * The contents	of this	file are subject to the	terms
 * of the Common Development and Distribution License
 * (the	License).  You may not use this	file except in
 * compliance with the License.
 *
 * You can obtain a copy of the	license	at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When	distributing Covered Code, include this	CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with	the fields enclosed by brackets	[] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year]	[name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * EntityManagerMethod.java
 * $Id: EntityManagerMethod.java,v 1.1 2006/11/08 20:55:16 harpreet Exp $
 * $Date: 2006/11/08 20:55:16 $
 * $Revision: 1.1 $
 */

package	com.sun.enterprise.admin.monitor.callflow;

public enum EntityManagerMethod {

    PERSIST {
        public String toString() {
            return "persist(Object entity)";
        }
    },
    
    MERGE {
        public String toString() {
            return "merge(<T> entity)";
        }
    },
    
    REMOVE {
        public String toString() {
            return "remove(Object entity)";
        }
    },
    
    FIND {
        public String toString() {
            return "find(Class<T> entityClass, Object primaryKey)";
        }
    },

    GET_REFERENCE {
        public String toString() {
            return "getReference(Class<T> entityClass, Object primaryKey)";
        }
    },
    
    FLUSH {
        public String toString() {
            return "flush()";
        }
    },
  
    SET_FLUSH_MODE {
        public String toString() {
            return "setFlushMode(FlushModeType flushMode)";
        }
    },
    
    GET_FLUSH_MODE {
        public String toString() {
            return "getFlushMode()";
        }
    },

    LOCK {
        public String toString() {
            return "lock(Object entity, LockModeType lockMode)";
        }
    },

    REFRESH {
        public String toString() {
            return "refresh(Object entity)";
        }
    },
    
    CLEAR {
        public String toString() {
            return "clear()";
        }
    },

    CONTAINS {
        public String toString() {
            return "contains(Object entity)";
        }
    },
    
    CREATE_QUERY {
        public String toString() {
            return "createQuery(String qlString)";
        }
    },
    
    CREATE_NAMED_QUERY {
        public String toString() {
            return "createNamedQuery(String name)";
        }
    },
    
    CREATE_NATIVE_QUERY_STRING {
        public String toString() {
            return "createNativeQuery(String sqlString)";
        }
    },
    
    CREATE_NATIVE_QUERY_STRING_CLASS {
        public String toString() {
            return "createNativeQuery(String sqlString, Class resultClass)";
        }
    },
    
    CREATE_NATIVE_QUERY_STRING_STRING {
        public String toString() {
            return "createNativeQuery(String sqlString, String resultSetMapping)";
        }
    },
    
    JOIN_TRANSACTION {
        public String toString() {
            return "joinTransaction()";
        }
    },

    GET_DELEGATE {
        public String toString() {
            return "getDelegate()";
        }
    },

    CLOSE {
        public String toString() {
            return "close()";
        }
    },
    
    IS_OPEN {
        public String toString() {
            return "isOpen()";
        }
    },
    
    GET_TRANSACTION {
        public String toString() {
            return "getTransaction()";
        }
    }
    
}
