/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.corba.ee.internal.util;

import java.util.logging.Logger;

import java.lang.reflect.Method;
import java.lang.reflect.Field;

//QQ. remove unnecessary import
//import com.sun.corba.ee.internal.orbutil.ORBConstants;

import java.util.MissingResourceException;

public class LogWrap {
    
    public static Logger logger;
    
    private static final String LOGDOMAINS_CLASS_NAME = 
            "com.sun.logging.LogDomains";
    private static final String GET_LOGGER_METHOD_NAME = "getLogger";

    private static final String ORB_LOGGER_FIELD_NAME = "CORBA_LOGGER";
    private static final String ORB_LOGGER_NAME = 
            "javax.enterprise.resource.corba";
    private static final String ORB_LOGGER_RESOURCE_BUNDLE =
            "com.sun.logging.enterprise.resource.corba.LogStrings";
    
    static {
        try {
            logger = getLoggerUsingLogDomainsAPI();
            if (logger == null) {
                System.out.println("Could not initialize LogDomains logger");
            }
        } catch (Exception ex) {
            System.out.println("Could not initialize LogDomains logger");
        }                

        if (logger == null) {
            try {
                logger = getLoggerUsingJavaLoggingAPI();
                if (logger == null) {
                    System.out.println("Could not initialize JDK logger");
                }
            } catch (Exception ex) {
                System.out.println("Could not initialize JDK logger");
                ex.printStackTrace();
            }
        }
    }
    
    private static Logger getLoggerUsingLogDomainsAPI() throws Exception {
        Class logDomainsClass = Class.forName(LOGDOMAINS_CLASS_NAME);

        Class [] parameterClasses = new Class[1];
        parameterClasses[0] = String.class;
        Method getLoggerMethod = logDomainsClass.getDeclaredMethod(
                GET_LOGGER_METHOD_NAME, parameterClasses);

        Field orbLoggerNameField = logDomainsClass.getDeclaredField(
                ORB_LOGGER_FIELD_NAME);
        String orbLoggerName = (String)orbLoggerNameField.get(null);

        Object [] parameters = new Object[1];
        parameters[0] = orbLoggerName;
        Logger lgr = (Logger)getLoggerMethod.invoke(null, parameters);

        return lgr;
    }
    
    private static Logger getLoggerUsingJavaLoggingAPI() throws Exception {
        Logger lgr = Logger.getLogger(ORB_LOGGER_NAME, ORB_LOGGER_RESOURCE_BUNDLE);
        
        return lgr;
    }
    
}
