/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment;

import java.util.*;
import com.sun.enterprise.util.LocalStringManagerImpl;

/**
 * This descriptor represents a specification of a transactional behavior.
 * 
 * @author Danny Coward
 */

public final class ContainerTransaction extends Descriptor {
    private String transactionAttribute;
    /** Transactions are not supported. */
    public static final String NOT_SUPPORTED = "NotSupported";
    /** Transactions need support. */
    public static final String SUPPORTS = "Supports";
    /** A transaction is required. */
    public static final String REQUIRED = "Required";
    /** A new transaction must be created. */
    public static final String REQUIRES_NEW = "RequiresNew";
    /** Transaction is mandatory.*/
    public static final String MANDATORY = "Mandatory";
    /** Never supply a transaction. */
    public static final String NEVER = "Never";
    private static final LocalStringManagerImpl localStrings =
	    new LocalStringManagerImpl(ContainerTransaction.class);
    
    /**
     * Copy constructor.
     */
    public ContainerTransaction(ContainerTransaction other) {
	if (other != null) {
	    this.transactionAttribute = other.transactionAttribute;
	    this.setDescription(other.getDescription());
	}
    }
    
    /**
     * Create a new transaction descriptor with the given attribute. Throws 
     * an IllegalArgumentException if the attribute is not an allowed type. 
     * The allowed types are enumeration ny this class.
     * @param the transaction attribute.
     * @param the description.
     */
    public ContainerTransaction(String transactionAttribute, 
				String description) {
	super("a Container Transaction", description);
	boolean isValidAttribute = (NOT_SUPPORTED.equals(transactionAttribute)
	    || SUPPORTS.equals(transactionAttribute)
		|| REQUIRED.equals(transactionAttribute)
		    || REQUIRED.equals(transactionAttribute)
			|| REQUIRES_NEW.equals(transactionAttribute)
			    || MANDATORY.equals(transactionAttribute)
				|| NEVER.equals(transactionAttribute) );
	if (!isValidAttribute && this.isBoundsChecking()) {
	    throw new IllegalArgumentException(localStrings.getLocalString(
			"enterprise.deployment.exceptionunknowncontainertxtype",
			"Unknown ContainerTransaction type: {0}", 
			new Object[] {transactionAttribute}));
	} else {
	    this.transactionAttribute = transactionAttribute;
	}
    }
    
    /**
     * The transaction attribute that I specify.
     * @return the transaction attribute.
     */
    public String getTransactionAttribute() {
	return this.transactionAttribute;
    }
    
    /** 
     * Equality iff the other object is another container transaction with the 
     * same transaction attribute.
     * @return true if the objects are equal, false otherwise.
     */
    public boolean equals(Object other) {
	if (other != null && other instanceof ContainerTransaction) {
	    ContainerTransaction otherContainerTransaction = 
			    (ContainerTransaction) other;
	    if (otherContainerTransaction.getTransactionAttribute().equals(
					this.getTransactionAttribute())) {
		return true;
	    }
	}
	return false;
    }
    
    /**
     * Returns a formatted String representing my state.
     */
    public void print(StringBuffer toStringBuffer) {
	toStringBuffer.append("Container Transaction: ").append(this.getTransactionAttribute()).append("@").append(this.getDescription());
    }
}

