/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment;

import java.util.Map;
import java.util.HashMap;

import javax.persistence.PersistenceContextType;

import com.sun.enterprise.deployment.types.EntityManagerReference;

/**
 * An object representing an component environment reference 
 * to an EntityManager
 *
*/
public class EntityManagerReferenceDescriptor extends 
    EnvironmentProperty implements EntityManagerReference {

    private String unitName = null;
    private PersistenceContextType contextType = PersistenceContextType.TRANSACTION;
    private BundleDescriptor referringBundle;

    private Map<String, String> properties = new HashMap<String,String>();

    public EntityManagerReferenceDescriptor(String name, 
                                            String unitName,
                                            PersistenceContextType type) {
        super(name, "", "");

        this.unitName = unitName;
        this.contextType = type;
    }

    public EntityManagerReferenceDescriptor() {}

    public void setUnitName(String unitName) {
        
        this.unitName = unitName;
    }

    public String getUnitName() {

        return unitName;

    }

    public String getInjectResourceType() {
        return "javax.persistence.EntityManager";
    }

    public void setInjectResourceType(String resourceType) {
    }

    public void setPersistenceContextType(PersistenceContextType type) {

        contextType = type;

    }

    public PersistenceContextType getPersistenceContextType() {

        return contextType;

    }

    public void addProperty(String name, String value) {
        properties.put(name, value);
    }

    public Map<String,String> getProperties() {
        return new HashMap<String,String>(properties);
    }

    public void setReferringBundleDescriptor(BundleDescriptor referringBundle)
    {
	this.referringBundle = referringBundle;
    }

    public BundleDescriptor getReferringBundleDescriptor()
    {
	return referringBundle;
    }  
    
}

