/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment;

/**
 * This class encapsulates the Resource Principal information needed
 * to access the Resource.
 *
 * @author Tony Ng
 */
public class ResourcePrincipal extends  PrincipalImpl {
    private String password;

    static private final int NULL_HASH_CODE = Integer.valueOf(1).hashCode();

    // start IASRI 4676199
    // Mods:
    // - Adding support for default principal cases where a principal
    //          is not needed to acquire a resource. Ex: when username and
    //          password are set on a jdbc datasource, no principal is need
    //          to call getConnection()

    //used for hashCode()
    private static final String DEFAULT_USERNAME = "__default__user__name__";
    //used for hashCode()
    private static final String DEFAULT_PASSWORD = "__default__password__";

    private boolean defaultPrincipal = false;

    /**
     * This constructor is used to construct a default principal. a default
     * principal is used when username and password are not required to 
     * acquire a resource.
     */
    public ResourcePrincipal() {
        super(DEFAULT_USERNAME);
        this.password = DEFAULT_PASSWORD;
        defaultPrincipal = true;
    }

    // end IASRI 4676199

    public ResourcePrincipal(String name, String password) {
        super(name);
        this.password = password;
    }

    public String getPassword() {
        return password;
    }

    // start IASRI 4676199
    /**
     * @return true if this principal is a default principal
     * @see ResourcePrincipal()
     */
    public boolean isDefault() {
        return defaultPrincipal;
    }
    // end IASRI 4676199

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null) return false;
        if (o instanceof ResourcePrincipal) {
            ResourcePrincipal other = (ResourcePrincipal) o;

            // start IASRI 4676199
            // handle the default principal case
            if (isDefault()) {
                return other.isDefault();
            } else if (other.isDefault()) {
                return false;
            }
            // end IASRI 4676199

            return ((isEqual(getName(), other.getName())) &&
                    (isEqual(this.password, other.password)));
        }
        return false;
    }

    public int hashCode() {
        int result = NULL_HASH_CODE;
        String name = getName();
        if (name != null) {
            result += name.hashCode();
        }
        if (password != null) {
            result += password.hashCode();
        }
        return result;
    }

    private boolean isEqual(Object a, Object b) {
        if (a == null) {
            return (b == null);
        } else {
            return (a.equals(b));
        }
    }

}
