/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;

import javax.annotation.security.DeclareRoles;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.Role;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.deployment.SecurityRoleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.annotation.AnnotationInfo;
import com.sun.enterprise.deployment.annotation.AnnotationProcessorException;
import com.sun.enterprise.deployment.annotation.HandlerProcessingResult;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import com.sun.enterprise.deployment.annotation.context.WebBundleContext;
import com.sun.enterprise.deployment.annotation.context.WebComponentContext;

/**
 * This handler is responsible for handling the
 * javax.annotation.security.DeclareRoles.
 *
 * @author Shing Wai Chan
 */
public class DeclareRolesHandler extends AbstractCommonAttributeHandler {
    
    public DeclareRolesHandler() {
    }
    
    /**
     * @return the annoation type this annotation handler is handling
     */
    public Class<? extends Annotation> getAnnotationType() {
        return DeclareRoles.class;
    }    
        
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo,
            EjbContext[] ejbContexts) throws AnnotationProcessorException {
        
        DeclareRoles rolesRefAn = (DeclareRoles)ainfo.getAnnotation();

        for (EjbContext ejbContext : ejbContexts) {
            EjbDescriptor ejbDescriptor = ejbContext.getDescriptor();
            for (String roleName : rolesRefAn.value()) {
                if (ejbDescriptor.getRoleReferenceByName(roleName) == null) {
                    RoleReference roleRef = new RoleReference(roleName, "");
                    roleRef.setRolename(roleName);
                    roleRef.setSecurityRoleLink(
                           new SecurityRoleDescriptor(roleName, ""));
                    ejbDescriptor.addRoleReference(roleRef);
                }

                Role role = new Role(roleName);
                ejbDescriptor.getEjbBundleDescriptor().addRole(role);
            }
        }
        return getDefaultProcessedResult();
    }   

    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo,
            WebComponentContext[] webCompContexts)
            throws AnnotationProcessorException { 
        WebBundleDescriptor webBundleDesc =
            webCompContexts[0].getDescriptor().getWebBundleDescriptor();
        return processAnnotation(ainfo, webBundleDesc);
    }

    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo,
             WebBundleContext webBundleContext)
             throws AnnotationProcessorException {
        WebBundleDescriptor webBundleDesc = webBundleContext.getDescriptor();
        return processAnnotation(ainfo, webBundleDesc);
    }

    private HandlerProcessingResult processAnnotation(AnnotationInfo ainfo,
             WebBundleDescriptor webBundleDesc) {
        DeclareRoles rolesRefAn = (DeclareRoles)ainfo.getAnnotation();
        for (String roleName : rolesRefAn.value()) {
            Role role = new Role(roleName);
            webBundleDesc.addRole(role);
        }
        return getDefaultProcessedResult();
    }

    /**
     * @return an array of annotation types this annotation handler would 
     * require to be processed (if present) before it processes it's own 
     * annotation type.
     */
    public Class<? extends Annotation>[] getTypeDependencies() {
        return getEjbAnnotationTypes();
    }

    protected boolean supportTypeInheritance() {
        return true;
    }
}
