/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node;

import org.xml.sax.Attributes;
import org.xml.sax.helpers.NamespaceSupport;

/**
 * This class represents a XML element in an XML file
 *
 * @author  Jerome Dochez
 * @version 
 */
public class XMLElement extends java.lang.Object {

    private String qName;
    private String prefix=null;
    private NamespaceSupport namespaces=null;
    
    /** Creates new XMLElement */
    public XMLElement(String qName) {
        this(qName, null);
    }

    public XMLElement(String qName, NamespaceSupport namespaceSupport) {
        if (qName.indexOf(':')!=-1) {
            prefix = qName.substring(0, qName.indexOf(':'));
            this.qName = qName.substring(qName.indexOf(':')+1);
        } else {
            this.qName = qName;
        }
        // can be null
        namespaces = namespaceSupport;
    }
    
    public String getQName() {
        return qName;
    }
    
    public String toString() {
        return qName;
    }
    
    public String getPrefix() {
        return prefix;
    }

    /**
     * Map a prefix to a namespaceURI based on the namespace context
     * of this XML element.
     */
    public String getPrefixURIMapping(String prefixToResolve) {
        return ( (namespaces != null) && (prefixToResolve != null) ) ? 
            namespaces.getURI(prefixToResolve) : null;
    }

    public String getCompleteName() {
        if (prefix!=null) {
            return prefix+":"+qName;
        } else {
            return qName;
        }
    }
   
    public boolean equals(XMLElement other ) {
        return qName.equals(other.getQName());
    }
}
