/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment.node.runtime;

import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.Node;

import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.MethodNode;
import com.sun.enterprise.deployment.runtime.FlushAtEndOfMethodDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.xml.RuntimeTagNames;

/**
 * This node handles the flush-at-end-of-method runtime deployment descriptors 
 *
 */
public class FlushAtEndOfMethodNode extends DeploymentDescriptorNode {

    protected FlushAtEndOfMethodDescriptor descriptor=null;
    
    /** Creates new FlushAtEndOfMethodNode */
    public FlushAtEndOfMethodNode() {
        registerElementHandler(new XMLElement(RuntimeTagNames.METHOD), MethodNode.class);   
    }
    
   /**
    * @return the descriptor instance to associate with this XMLNode
    */    
    public Object getDescriptor() {
        if (descriptor==null) {
            descriptor = new FlushAtEndOfMethodDescriptor();
            Object parentDesc = getParentNode().getDescriptor();
            if (parentDesc instanceof EjbDescriptor) {
                descriptor.setEjbDescriptor((EjbDescriptor)parentDesc);
            }
        }
        return descriptor;
    }
    

    /**
     * Adds a new DOL descriptor instance to the descriptor instance associated
     * with this XMLNode
     *
     * @param descriptor the new descriptor
     */
    public void addDescriptor(Object newDescriptor) {
        if (newDescriptor instanceof MethodDescriptor) {
            descriptor.addMethodDescriptor(
                (MethodDescriptor) newDescriptor);
        }
    }

    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node for the DOM tree
     * @param node name for the descriptor
     * @param the descriptor to write
     * @return the DOM tree top node
     */    
    public Node writeDescriptor(Node parent, String nodeName, 
        FlushAtEndOfMethodDescriptor flushMethodDescriptor) {    
	Node flushMethodNode = super.writeDescriptor(parent, nodeName, 
            flushMethodDescriptor);
        ArrayList methodDescs = flushMethodDescriptor.getConvertedMethodDescs();
        if (!methodDescs.isEmpty()) {
            MethodNode methodNode = new MethodNode();
            for (Iterator methodIterator = methodDescs.iterator();
                methodIterator.hasNext();) {
                MethodDescriptor methodDesc = 
                    (MethodDescriptor) methodIterator.next();
                // do not write out ejb-name element for the method
                methodNode.writeDescriptor(flushMethodNode, 
                    RuntimeTagNames.METHOD, methodDesc, null);
            }
        }

	return flushMethodNode;
    }
}
