/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node.runtime;

import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.xml.RuntimeTagNames;

import com.sun.enterprise.deployment.MailConfiguration;

/**
 * This node handles the runtime deployment descriptor tag 
 * default-resource-principal
 *
 * @author  Jerome Dochez
 * @version 
 */
public class MailConfigurationNode extends DeploymentDescriptorNode {

    private String name = null;
    private String mail_from = null;
    private String mail_host = null;
    
    /**
     * receives notification of the value for a particular tag
     * 
     * @param element the xml element
     * @param value it's associated value
     */
    public void setElementValue(XMLElement element, String value) {
        if (RuntimeTagNames.NAME.equals(element.getQName())) {
            name = value;
        } else  if (RuntimeTagNames.MAIL_FROM.equals(element.getQName())) {
            mail_from = value;
        } else  if (RuntimeTagNames.MAIL_HOST.equals(element.getQName())) {
            mail_host = value;
        }
    }
        
    /**
     * notification of the end of XML parsing for this node
     */
    public void postParsing() {
        getParentNode().addDescriptor(new MailConfiguration(name, mail_from, mail_host));                    
    }
}