/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
package com.sun.enterprise.deployment.node.runtime;

import java.util.Iterator;
import org.w3c.dom.Node;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.MessageDestinationDescriptor;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.RootXMLNode;
import com.sun.enterprise.deployment.xml.RuntimeTagNames;

public abstract class RuntimeBundleNode extends DeploymentDescriptorNode implements RootXMLNode {

    protected Descriptor descriptor=null;
    
    public RuntimeBundleNode(Descriptor descriptor) {
        this.descriptor = descriptor;
	Init();
    }   

    public RuntimeBundleNode() {
        this(null);
    } 
    
    /**
     * Initializes the child handler;
     */
    protected void Init() {
	// we do not care about standard DDs common tags
	handlers=null;
    }
    
    /**
     * Adds  a new DOL descriptor instance to the descriptor instance associated with 
     * this XMLNode
     *
     * @param descriptor the new descriptor
     */
    public void addDescriptor(Object descriptor) {    
        return;
    }
    
   /**
    * @return the descriptor instance to associate with this XMLNode
    */    
    public Object getDescriptor() {
        return descriptor;
    } 
    
    /**
     * @return the default spec version level this node complies to
     */
    public String getSpecVersion() {
        return "1.4";
    }
    
    /**
     * set the DOCTYPE as read in the input XML File
     * @param DOCTYPE
     */
    public void setDocType(String docType) {
        // I do not care about the version of the runtime descriptors
    }
    
    /**
     * Sets the specVersion for this descriptor depending on the docType
     */
    protected void setSpecVersion() {
        // I do not care about the version of the runtime descriptors
    }  

    /**
     * writes the message destination references runtime information
     */
    protected void writeMessageDestinationInfo(Node parent, 
                                               BundleDescriptor descriptor) {
        for(Iterator iter = descriptor.getMessageDestinations().iterator();
            iter.hasNext();) {
            MessageDestinationRuntimeNode node = 
                new MessageDestinationRuntimeNode();
            node.writeDescriptor(parent, RuntimeTagNames.MESSAGE_DESTINATION,
                                 (MessageDestinationDescriptor) iter.next());
        }
    }    
    
    /** 
     * @return true if the runtime bundle node should only process
     * the product FCS DTD declarations
     */
    protected static final boolean restrictDTDDeclarations() {
        if (restrictDTDDeclarations==null) {
            restrictDTDDeclarations = Boolean.valueOf(Boolean.getBoolean("com.sun.aas.deployment.restrictdtddeclarations"));
        }
        return restrictDTDDeclarations.booleanValue();
    }
    
    private static Boolean restrictDTDDeclarations=null;
}
