/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * @(#) BeanCache.java
 *
 * Copyright 2000-2001 by iPlanet/Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of iPlanet/Sun Microsystems, Inc. ("Confidential Information").
 * You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license
 * agreement you entered into with iPlanet/Sun Microsystems.
 */

package com.sun.enterprise.deployment.runtime;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.DescriptorConstants;

/** iAS specific DD Element (see the ias-ejb-jar_2_0.dtd for this element)
 * @author Ludo
 * @since JDK 1.4
 */
public class BeanCacheDescriptor extends Descriptor implements DescriptorConstants{

        private Boolean isCacheOverflowAllowed;       
        private String victimSelectionPolicy;
        
        //initialized default values for class variables
        private int maxCacheSize = MAX_CACHE_SIZE_DEFAULT;
        private int resizeQuantity = RESIZE_QUANTITY_DEFAULT;
        private int cacheIdleTimeoutInSeconds = CACHE_IDLE_TIMEOUT_DEFAULT;
        private int removalTimeoutInSeconds = REMOVAL_TIMEOUT_DEFAULT; 
        
        /** Default constructor. */
	public BeanCacheDescriptor() {
	}

        /** 
         * Getter for property cacheIdleTimeoutInSeconds.
         * @return Value of property cacheIdleTimeoutInSeconds.
         */
        public int getCacheIdleTimeoutInSeconds() {
            return cacheIdleTimeoutInSeconds;
        }        
        
        /** 
         * Setter for property cacheIdleTimeoutInSeconds.
         * @param cacheIdleTimeoutInSeconds New value of property cacheIdleTimeoutInSeconds.
         */

        public void setCacheIdleTimeoutInSeconds(int cacheIdleTimeoutInSeconds) {
            this.cacheIdleTimeoutInSeconds = cacheIdleTimeoutInSeconds;
        }
        
        /** 
         * Getter for property isCacheOverflowAllowed.
         * @return Value of property isCacheOverflowAllowed.
         */
        public Boolean isIsCacheOverflowAllowed() {
            return isCacheOverflowAllowed;
        }
        
        /** 
         * Setter for property isCacheOverflowAllowed.
         * @param isCacheOverflowAllowed New value of property isCacheOverflowAllowed.
         */
        public void setIsCacheOverflowAllowed(boolean isCacheOverflowAllowed) {
            this.isCacheOverflowAllowed =  Boolean.valueOf(isCacheOverflowAllowed);
        }
        
        /** 
         * Setter for property isCacheOverflowAllowed.
         * @param isCacheOverflowAllowed New value of property isCacheOverflowAllowed.
         */
        public void setIsCacheOverflowAllowed(Boolean isCacheOverflowAllowed) {
            this.isCacheOverflowAllowed =  isCacheOverflowAllowed;
        }

        /** 
         * Getter for property maxCacheSize.
         * @return Value of property maxCacheSize.
         */
        public int getMaxCacheSize() {
            return maxCacheSize;
        }
        
        /** 
         * Setter for property maxCacheSize.
         * @param maxCacheSize New value of property maxCacheSize.
         */
        public void setMaxCacheSize(int maxCacheSize) {
            this.maxCacheSize = maxCacheSize;
        }
        
        /** 
         * Getter for property resizeQuantity.
         * @return Value of property resizeQuantity.
         */
        public int getResizeQuantity() {
            return resizeQuantity;
        }
        
        /** 
         * Setter for property resizeQuantity.
         * @param resizeQuantity New value of property resizeQuantity.
         */
        public void setResizeQuantity(int resizeQty) {
            this.resizeQuantity = resizeQty;
        }
        
        /** 
         * Getter for property removalTimeoutInSeconds.
         * @return Value of property removalTimeoutInSeconds.
         */
        public int getRemovalTimeoutInSeconds() {
            return removalTimeoutInSeconds;
        }
        
        /** 
         * Setter for property removalTimeoutInSeconds.
         * @param removalTimeoutInSeconds New value of property removalTimeoutInSeconds.
         */
        public void setRemovalTimeoutInSeconds(int removalTimeoutInSeconds) {
            this.removalTimeoutInSeconds = removalTimeoutInSeconds;
        }
        
        /** 
         * Getter for property victimSelectionPolicy.
         * @return Value of property victimSelectionPolicy.
         */
        public java.lang.String getVictimSelectionPolicy() {
            return victimSelectionPolicy;
        }
        
        /** 
         * Setter for property victimSelectionPolicy.
         * @param victimSelectionPolicy New value of property victimSelectionPolicy.
         */
        public void setVictimSelectionPolicy(java.lang.String victimSelectionPolicy) {
            this.victimSelectionPolicy = victimSelectionPolicy;
        }
}
