/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.runtime.web;

import com.sun.enterprise.deployment.runtime.RuntimeDescriptor;

/**
* this class contains runtime information for the web bundle 
* it was kept to be backward compatible with the schema2beans descriptors
* generated by iAS 7.0 engineering team.
*
* @author Jerome Dochez
*/
public class LocaleCharsetInfo extends RuntimeDescriptor
{
    
    static public final String LOCALE_CHARSET_MAP = "LocaleCharsetMap";	// NOI18N
    static public final String PARAMETER_ENCODING = "ParameterEncoding";	// NOI18N
    static public final String FORM_HINT_FIELD = "FormHintField"; // NOI18N
    static public final String DEFAULT_LOCALE = "DefaultLocale";  // NOI18N
    static public final String DEFAULT_CHARSET = "DefaultCharset";
    
    // This attribute is an array containing at least one element
    public void setLocaleCharsetMap(int index, LocaleCharsetMap value)
    {
	this.setValue(LOCALE_CHARSET_MAP, index, value);
    }
    
    //
    public LocaleCharsetMap getLocaleCharsetMap(int index)
    {
	return (LocaleCharsetMap)this.getValue(LOCALE_CHARSET_MAP, index);
    }
    
    // This attribute is an array containing at least one element
    public void setLocaleCharsetMap(LocaleCharsetMap[] value)
    {
	this.setValue(LOCALE_CHARSET_MAP, value);
    }
    
    //
    public LocaleCharsetMap[] getLocaleCharsetMap()
    {
	return (LocaleCharsetMap[])this.getValues(LOCALE_CHARSET_MAP);
    }
    
    // Return the number of properties
    public int sizeLocaleCharsetMap()
    {
	return this.size(LOCALE_CHARSET_MAP);
    }
    
    // Add a new element returning its index in the list
    public int addLocaleCharsetMap(LocaleCharsetMap value)
    {
	return this.addValue(LOCALE_CHARSET_MAP, value);
    }	
    
    //
    // Remove an element using its reference
    // Returns the index the element had in the list
    //
    public int removeLocaleCharsetMap(LocaleCharsetMap value)
    {
	return this.removeValue(LOCALE_CHARSET_MAP, value);
    }
    
    // This attribute is optional
    public void setParameterEncoding(boolean value)
    {
	this.setValue(PARAMETER_ENCODING, Boolean.valueOf(value));
    }
    
    //
    public boolean isParameterEncoding()
    {
	Boolean ret = (Boolean)this.getValue(PARAMETER_ENCODING);
	if (ret == null) {
	    return false;
	}
	return ret.booleanValue();
    }
    
    // This method verifies that the mandatory properties are set
    public boolean verify()
    {
	return true;
    }
}
