/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment.util;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.RelationshipDescriptor;
import com.sun.enterprise.deployment.WebService;

/**
 * This class defines a Visitor API for the DOL Ejb bundle related 
 * descriptors. 
 *
 * @author  Jerome Dochez
 * @version 
 */
public interface EjbBundleVisitor extends ComponentVisitor {

    /**
     * visits an ejb bundle descriptor
     * @param an ejb bundle descriptor
     */
    public void accept(EjbBundleDescriptor bundleDescriptor);    

    /**
     * visits each web service declared within an ejb-jar.
     */
    public void accept(WebService webService);

    /**
     * visits an ejb relationship descriptor
     * @param the relationship descriptor
     */
    public void accept(RelationshipDescriptor descriptor);
    
    /**
     * @return a EjbVisitor (if ejbs should be visited) 
     */ 
    public EjbVisitor getEjbVisitor();

}

