/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.util;

import java.net.URL;
import java.net.MalformedURLException;

/**
 * This class holds information about a particular web server 
 * installation, its running engines and so on...
 *
 * @author Jerome Dochez
 */
public class WebServerInfo {
    
    /**
     * Holds value of property httpVS.
     */
    private VirtualServerInfo httpVS;
    
    /**
     * Holds value of property httpsVS.
     */
    private VirtualServerInfo httpsVS;
    
    /** Creates a new instance of WebServerInfo */
    public WebServerInfo() {
    }
    
    /**
     * Getter for property httpVS.
     * @return Value of property httpVS.
     */
    public VirtualServerInfo getHttpVS() {
        return this.httpVS;
    }
    
    /**
     * Setter for property httpVS.
     * @param httpVS New value of property httpVS.
     */
    public void setHttpVS(VirtualServerInfo httpVS) {
        this.httpVS = httpVS;
    }
    
    /**
     * Getter for property httpsVS.
     * @return Value of property httpsVS.
     */
    public VirtualServerInfo getHttpsVS() {
        return this.httpsVS;
    }
    
    /**
     * Setter for property httpsVS.
     * @param httpsVS New value of property httpsVS.
     */
    public void setHttpsVS(VirtualServerInfo httpsVS) {
        this.httpsVS = httpsVS;
    }
    
    public URL getWebServerRootURL(boolean secure) throws MalformedURLException {
        if (secure) {
            if (httpsVS!=null)
                return httpsVS.getWebServerRootURL();
            
        } else {
            if (httpVS!=null) 
                return httpVS.getWebServerRootURL();
        }
        return null;
    }
     
}
