package com.sun.enterprise.util.io;

import java.io.*;


///////////////////////////////////////////////////////////////////////////

class ProcessStreamDrainerWorker implements Runnable
{
    ProcessStreamDrainerWorker(InputStream in)
    {
        this(in, null);
    }

    ProcessStreamDrainerWorker(InputStream in, PrintStream Redirect)
    {
        if(in == null)
            throw new NullPointerException("InputStream argument was null.");
        
        reader = new BufferedInputStream(in);
        redirect = Redirect;
    }
    
    public void run()
    {
        if(reader == null)
            return;
        
        try
        {
            int count = 0;
            byte[] buffer = new byte[4096];
            
            while ((count = reader.read(buffer)) != -1)
            {
                if(redirect != null)
                    redirect.write(buffer, 0, count);
            }
        } 
        catch (IOException e)
        {
        }
    }
    
    private final BufferedInputStream reader;
    private final PrintStream redirect;
}