/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.base.container.util;

import java.util.logging.Logger;
import java.util.logging.Level;

import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.*;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.runtime.IASEjbExtraDescriptors;
import com.sun.enterprise.deployment.runtime.BeanCacheDescriptor;

import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.util.Utility;

import com.sun.logging.LogDomains;

/**
 * A util class to read the bean cache related entries from 
 *  domain.xml and sun-ejb-jar.xml
 *
 * @author Mahesh Kannan
 */
public class CacheProperties {

    protected static final Logger _logger =
        LogDomains.getLogger(LogDomains.EJB_LOGGER);
        
    private int maxCacheSize ;
    private int numberOfVictimsToSelect ;
    private int cacheIdleTimeoutInSeconds ;
    private int removalTimeoutInSeconds;

    private String victimSelectionPolicy;
        
    public CacheProperties(EjbDescriptor desc) {
        
        try {
            BeanCacheDescriptor beanCacheDes = null;
            Config cfg = null;
         
            IASEjbExtraDescriptors iased = desc.getIASEjbExtraDescriptors();
            if( iased != null) {
                beanCacheDes = iased.getBeanCache();
            }
        
            EjbContainer ejbContainer = null;
            ServerContext sc = ApplicationServer.getServerContext();
            cfg = ServerBeansFactory.getConfigBean(sc.getConfigContext());
            ejbContainer = cfg.getEjbContainer();

            loadProperties(ejbContainer, beanCacheDes);
            //container.setMonitorOn(ejbContainer.isMonitoringEnabled());
        }  catch (ConfigException ex) {
            _logger.log(Level.SEVERE, "", ex);
        }
    }   

    public int getMaxCacheSize() {
	return this.maxCacheSize;
    }

    public int getNumberOfVictimsToSelect() {
	return this.numberOfVictimsToSelect;
    }

    public int getCacheIdleTimeoutInSeconds() {
	return this.cacheIdleTimeoutInSeconds;
    }

    public int getRemovalTimeoutInSeconds() {
	return this.removalTimeoutInSeconds;
    }

    public String getVictimSelectionPolicy() {
	return this.victimSelectionPolicy;
    }
        
    public String toString() {
	StringBuffer sbuf = new StringBuffer();
	sbuf.append("maxSize: ").append(maxCacheSize)
	    .append("; victims: ").append(numberOfVictimsToSelect)
	    .append("; idleTimeout: ").append(cacheIdleTimeoutInSeconds)
	    .append("; removalTimeout: ").append(removalTimeoutInSeconds)
	    .append("; policy: ").append(victimSelectionPolicy);

	return sbuf.toString();
    }
        
    private void loadProperties(EjbContainer ejbContainer, 
	BeanCacheDescriptor beanCacheDes)
    {
	numberOfVictimsToSelect = 
	    new Integer(ejbContainer.getCacheResizeQuantity()).intValue();

	maxCacheSize =
	    new Integer(ejbContainer.getMaxCacheSize()).intValue();

	cacheIdleTimeoutInSeconds = new Integer(
		ejbContainer.getCacheIdleTimeoutInSeconds()).intValue();

	removalTimeoutInSeconds =
	    new Integer(ejbContainer.getRemovalTimeoutInSeconds()).intValue();

	victimSelectionPolicy = ejbContainer.getVictimSelectionPolicy();

	if (beanCacheDes != null) {
	    int temp = 0;
	    if ((temp =  beanCacheDes.getResizeQuantity()) != -1) {
		this.numberOfVictimsToSelect = temp;
	    }
	    if ((temp = beanCacheDes.getMaxCacheSize()) != -1) {
		this.maxCacheSize = temp;
	    }                              
	    if ((temp = beanCacheDes.getCacheIdleTimeoutInSeconds()) != -1){
		this.cacheIdleTimeoutInSeconds = temp;
	    }                
	    if ((temp = beanCacheDes.getRemovalTimeoutInSeconds()) != -1) {
		this.removalTimeoutInSeconds = temp;
	    }
	    if (( beanCacheDes.getVictimSelectionPolicy()) != null) {
		this.victimSelectionPolicy = 
		    beanCacheDes.getVictimSelectionPolicy();
	    }
	}
    }

}
   
