/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.base.stats;

import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.TimeStatistic;
import javax.management.j2ee.statistics.BoundedRangeStatistic;

import com.sun.enterprise.admin.monitor.stats.EJBCacheStats;
import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.TimeStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.MutableTimeStatisticImpl;

import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistrationException;

import java.util.logging.*;
import com.sun.enterprise.log.Log;
import com.sun.logging.*;


/**
 * A Class for providing stats for Bean Methods
 *  Used by both Entity, Stateless and Stateful Container
 *
 * @author Mahesh Kannan
 */

public class EJBMethodStatsImpl
    extends StatsImpl
    implements com.sun.enterprise.admin.monitor.stats.EJBMethodStats
{
    private MethodMonitor delegate;

    private MethodMonitor   methodMonitor;

    private MutableCountStatisticImpl executionStat;
    private MutableCountStatisticImpl errorStat;
    private MutableTimeStatisticImpl  methodStat;
    private MutableCountStatisticImpl successStat;

    public EJBMethodStatsImpl(MethodMonitor delegate) {
	this.delegate = delegate;

	initialize();
    }

    private void initialize() {
	super.initialize("com.sun.enterprise.admin.monitor.stats.EJBMethodStats");

	executionStat = new MutableCountStatisticImpl(
		new CountStatisticImpl("ExecutionTime", "Milliseconds" ));
	errorStat = new MutableCountStatisticImpl(
		new CountStatisticImpl("TotalNumErrors"));

	long now = System.currentTimeMillis();
	methodStat = new MutableTimeStatisticImpl(
		new TimeStatisticImpl(0, 0, 0, 0,
		    "MethodStatistic", "", "", now, now));
	successStat = new MutableCountStatisticImpl(
		new CountStatisticImpl("TotalNumSuccess"));

	delegate.setMutableTimeStatisticImpl(methodStat);
    }

    public CountStatistic getExecutionTime() {
	executionStat.setCount(delegate.getExecutionTime());
	return (CountStatistic) executionStat.modifiableView();
    }

    public CountStatistic getTotalNumErrors() {
	errorStat.setCount(delegate.getTotalNumErrors());
	return (CountStatistic) errorStat.modifiableView();
    }

    public TimeStatistic getMethodStatistic() {
	return (TimeStatistic) methodStat.modifiableView();
    }

    public CountStatistic getTotalNumSuccess() {
	successStat.setCount(delegate.getTotalNumSuccess());
	return (CountStatistic) successStat.modifiableView();
    }

    protected void resetAllStats() {
	//Implementations must override this to reset stat values

	executionStat.reset();
	errorStat.reset();
	synchronized (methodStat) {
	    methodStat.reset();
	}
	successStat.reset();

	delegate.resetAllStats(monitorOn);
    }

}
