/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.ejb.containers;

import javax.ejb.EnterpriseBean;

/**
 * Implementation of EJBContext for ReadOnlyBeans. Contains extra
 * attributes that allows selective ejbLoad()
 *
 * @author Mahesh Kannan
 */

public final class ReadOnlyContextImpl
    extends EntityContextImpl
{
    private int pkLevelSequenceNum;
    private long lastRefreshedAt;   
    private boolean removed = false;

    // only non-null when associated with a primary-key
    private ReadOnlyBeanInfo robInfo;
    
    ReadOnlyContextImpl(EnterpriseBean ejb, BaseContainer container) {
        super(ejb, container);
    }

    public int getPKLevelSequenceNum() {
        return pkLevelSequenceNum;
    }

    public void incrementPKLevelSequenceNum() {
        pkLevelSequenceNum++;
    }

    public void setPKLevelSequenceNum(int num) {
        pkLevelSequenceNum = num;
    }

    public long getLastRefreshedAt() {
        return lastRefreshedAt;
    }
    
    public void setLastRefreshedAt(long time) {
        lastRefreshedAt = time;
    }
    
    public boolean isRemoved() {
        return removed;
    }
    
    public void setRemoved(boolean value) {
        removed = value;
    }
    
    public void setReadOnlyBeanInfo(ReadOnlyBeanInfo info) {
        robInfo = info;

        // Whenever read-only bean info is set or nulled out, initialize
        // its derived fields.
        pkLevelSequenceNum = -1;
        lastRefreshedAt = 0;
    }

    public ReadOnlyBeanInfo getReadOnlyBeanInfo() {
        return robInfo;
    }
}
