/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.containers;

import java.util.ArrayList;

import com.sun.ejb.spi.sfsb.store.SFSBTxStoreManager;

import com.sun.ejb.base.sfsb.initialization.SFSBTxStoreManagerFactory;

import com.sun.ejb.base.sfsb.util.EJBServerConfigLookup;

import com.sun.ejb.spi.sfsb.store.SFSBBeanState;
import com.sun.ejb.spi.sfsb.store.SFSBStoreManagerException;

import java.util.logging.*;
import com.sun.logging.*;

/**
 * A class to checkpoint HA enabled SFSBs as a single transactional unit.
 *
 * @author Mahesh Kannan
 */
public class SFSBTxCheckpointCoordinator {

    private static final Logger _logger =
        LogDomains.getLogger(LogDomains.EJB_LOGGER);

    private static String _haStoreType;
    static {
	EJBServerConfigLookup ejbConfigLookup = new EJBServerConfigLookup();
	_haStoreType = ejbConfigLookup.getSfsbHaPersistenceTypeFromConfig();
    }

    private ArrayList	ctxList = new ArrayList();

    SFSBTxCheckpointCoordinator() {
    }

    void registerContext(SessionContextImpl ctx) {
	ctxList.add(ctx);
    }

    void doTxCheckpoint() {
	SessionContextImpl[] contexts = (SessionContextImpl[]) ctxList.toArray(
		new SessionContextImpl[0]);
	int size = contexts.length;
	ArrayList states = new ArrayList(size);

	for (int i=0; i<size; i++) {
	    SessionContextImpl ctx = contexts[i];
	    StatefulSessionContainer container =
		(StatefulSessionContainer) ctx.getContainer();
	    SFSBBeanState beanState = container.getSFSBBeanState(ctx);
	    if (beanState != null) {
		states.add(beanState);
	    }
	}

	if (states.size () > 0) {
	    SFSBBeanState[] beanStates = (SFSBBeanState[]) states.toArray(
		new SFSBBeanState[0]);

	    try {
		SFSBTxStoreManager txStoreManager = SFSBTxStoreManagerFactory.
		    createSFSBTxStoreManager(_haStoreType);
		txStoreManager.checkpointSave(beanStates);
	    } catch (SFSBStoreManagerException sfsbEx) {
		_logger.log(Level.WARNING, "Exception during checkpointSave",
			sfsbEx);
	    } catch (Throwable th) {
		_logger.log(Level.WARNING, "Exception during checkpointSave",
			th);
	    }
	}

	for (int i=0; i<size; i++) {
	    SessionContextImpl ctx = contexts[i];
	    StatefulSessionContainer container =
		(StatefulSessionContainer) ctx.getContainer();
	    container.txCheckpointCompleted(ctx);
	}
    }

}
