/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Filename: ContainerWorkPool.java
 *
 */

/**
 * <BR> <I>$Source: /cvs/glassfish/appserv-core/src/java/com/sun/ejb/containers/util/ContainerWorkPool.java,v $</I>
 * @author     $Author: mk111283 $
 * @version    $Revision: 1.4 $ $Date: 2006/12/23 13:48:56 $
 */

package com.sun.ejb.containers.util;

import com.sun.corba.ee.spi.orbutil.threadpool.Work;
import com.sun.corba.ee.spi.orbutil.threadpool.ThreadPoolManager;
import com.sun.corba.ee.spi.orbutil.threadpool.ThreadPool;
import com.sun.enterprise.util.S1ASThreadPoolManager;
import com.sun.enterprise.util.ORBManager;

import com.sun.enterprise.util.threadpool.Servicable;

import java.util.logging.Logger;
import java.util.logging.Level;
import com.sun.logging.LogDomains;

/**
 * This class implements a singleton instance which
 * is used by the container for its housekeeping tasks
 * using the default threadpool of the appserver
 */

public class ContainerWorkPool {

    public static final Logger _logger =
        LogDomains.getLogger(LogDomains.UTIL_LOGGER);

    public static void addLast(Servicable ser) {
        addLast(new WorkAdapter(ser));
    }

    public static void addFirst(Servicable ser) {
        addLast(new WorkAdapter(ser));
    }

    public static void addFirst(Work work) {
        addLast(work);
    }

    public static void addLast(Work work) {
        ThreadPoolManager threadpoolMgr =
            S1ASThreadPoolManager.getThreadPoolManager();
        ThreadPool threadpool = threadpoolMgr.getDefaultThreadPool();
        threadpool.getAnyWorkQueue().addWork(work);
    }

}

