/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.containers.util.cache;

import java.util.Properties;

import com.sun.ejb.spi.container.SFSBContainerCallback;

public class NRUSessionCache
    extends LruSessionCache
{ 

    protected boolean doOrdering = false;
    protected int orderingThreshold = 0;

    public NRUSessionCache(String cacheName, 
        SFSBContainerCallback container, int cacheIdleTime, int removalTime)
    {
        super("NRU-" + cacheName, container, cacheIdleTime, removalTime);
    }

    public void init(int maxEntries, float loadFactor, Properties props) {
        super.init(maxEntries, loadFactor, props);
        orderingThreshold = (int) (0.75 * threshold);
    }
    
    protected CacheItem itemAdded(CacheItem item) {
        CacheItem addedItem = super.itemAdded(item);
        doOrdering = (entryCount >= orderingThreshold);
        return addedItem;
    }
    
    protected void itemAccessed(CacheItem item) {
        LruCacheItem lc = (LruCacheItem) item;
        synchronized (this) {
            if (lc.isTrimmed) {
                lc.isTrimmed = false;
                CacheItem overflow = super.itemAdded(item);
                if (overflow != null) {
                    trimItem(overflow);
                }
            } else if (doOrdering) {
                super.itemAccessed(item);
            }
        }
    }

    protected void itemRefreshed(CacheItem item, int oldSize) {
    }
    
    protected void itemRemoved(CacheItem item) {
        super.itemRemoved(item);
        doOrdering = (entryCount >= orderingThreshold);
    }

    public void trimTimedoutItems(int  maxCount) {
        // If we are maintaining an ordered list use 
        // the superclass method for trimming
        if (doOrdering) {
            super.trimTimedoutItems(maxCount);
        } else {
            // we don't have an ordered list, 
            // so go through the whole cache and pick victims
            trimUnSortedTimedoutItems(maxCount);
        }
    }

}
