/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.spi.io;

import com.sun.enterprise.spi.io.BaseIndirectlySerializable;

/**
 * An interface that allows Non-Serializable objects
 *  to be persisted. Any non serializable object that
 *  needs to be persisted needs to implement this
 *  interface. The getSerializableObjectFactory()
 *  method will be called to get a SerilizableObjectFactory
 *  that can be persisted. The SerializableObjectFactory
 *  can later be de-serialized and the createObject()
 *  will be invoked to get the original Non-Serializable
 *  object. It is assumed that the SerializableObjectFactory
 *  contains enough data that can be used to restore the original
 *  state of the object that existed at the time of Serilization
 *
 * @author Mahesh Kannan
 */
public interface IndirectlySerializable extends BaseIndirectlySerializable {

    public SerializableObjectFactory getSerializableObjectFactory()
        throws java.io.IOException;

}
