/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.common;

//JMX imports
import javax.management.ObjectName;
import javax.management.MalformedObjectNameException;

import com.sun.enterprise.admin.util.ArgChecker;
import com.sun.enterprise.admin.common.exception.*;
import com.sun.enterprise.admin.common.ObjectNameHelper;

public class JMXExceptionTranslator
{
    private static final String NULL_ARGUMENT = "null-arg";

    public static AFException translate(Exception e)
    {
        ArgChecker.check((e != null), NULL_ARGUMENT);

        AFException afe = new AFException(e.getMessage());
        if (e instanceof javax.management.MBeanException)
        {
            Exception targetException = 
                ((javax.management.MBeanException)e).getTargetException();
            if (targetException instanceof AFException)
            {
                afe = (AFException) targetException;
            }
            // <addition> srini@sun.com server.xml verifier
            else if(targetException instanceof AFRuntimeException)
            {
                   throw (AFRuntimeException)targetException;
            }
	    else if (targetException instanceof javax.management.MBeanException)
	    {
                Exception excpn = 
			((javax.management.MBeanException)targetException).getTargetException();
		if (excpn != null) {
                   if (excpn instanceof javax.management.InvalidAttributeValueException) {
                      afe = new com.sun.enterprise.admin.common.exception.InvalidAttributeValueException(
				excpn.getLocalizedMessage());
		   }
		}
	    }
            // </addition>		
            else
            {
                afe = new AFOtherException(targetException);
            }
        }
        else if (e instanceof javax.management.InstanceNotFoundException)
        {
            String msg = convertInstanceNotFoundExceptionMessage(e);
            afe = new AFTargetNotFoundException(msg);
        }
        else if (e instanceof javax.management.ReflectionException)
        {
            afe = new AFOtherException(e);
        }
        else if (e instanceof javax.management.AttributeNotFoundException)
        {
            afe = new AttributeNotFoundException(e.getLocalizedMessage());
        }
        else if (e instanceof javax.management.InvalidAttributeValueException)
        {
            afe = new InvalidAttributeValueException(e.getLocalizedMessage());
        }
        else if (e instanceof java.lang.RuntimeException)
        {
            throw (java.lang.RuntimeException) e;
        }
        return afe;
    }

    private static String convertInstanceNotFoundExceptionMessage(Exception e)
    {
        /* Here we are trying to extract type and name from exception
         if message is valid ObjectName string representation */
        String type = null;
        String name = null;
        try
        {
            ObjectName objectName = new ObjectName(e.getMessage());
            type = ObjectNameHelper.getType(objectName);
            name = ObjectNameHelper.getName(objectName);
        }
        catch (MalformedObjectNameException mfone)
        {
        }
        String msg;
        if(type!=null)
        {
            if(name!=null)
                msg = type + " '" + name +"' is not found.";
            else
                msg = type + " is not found.";
        }
        else
        {
            //object name is malformed - leave original message
            msg = e.getLocalizedMessage();
        }
        return msg;
    }
}
