/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.event;

import java.util.ArrayList;
import java.util.Iterator;
import com.sun.enterprise.config.ConfigChange;

/**
 * Provides access to the thread local event stack.
 *
 * @author Nazrul Islam
 * @since  JDK1.4
 */
public class EventContext {

    /**
     * Returns the event stack from thread local.
     * @return  event stack from thread local
     */
    public static EventStack getEventStackFromThreadLocal() {
        return (EventStack) _threadLocal.get();
    }

    /**
     * Sets the event stack to thread local.
     * @param  stack  event stack info
     */
    public static void setEventStackToThreadLocal(EventStack stack) {
        _threadLocal.set(stack);
    }

    /**
     * Returns the config changes from config.
     * @return  list of config changes
     */
    public static ArrayList getConfigChangeList() {

        EventStack stack = getEventStackFromThreadLocal();
        return stack.getConfigContext().getConfigChangeList();
    }

    /**
     * Adds an event to the stack. The newly added event will be 
     * sent to the target destination.
     *
     * @param  event  an event 
     */
    public static void addEvent(AdminEvent event) {
        EventStack stack = getEventStackFromThreadLocal();
        stack.addEvent(event);
    }
    
    // ---- VARIABLE(S)-PRIVATE -----------------------------------
    private static InheritableThreadLocal _threadLocal = new InheritableThreadLocal();
}
