/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.event;

import javax.management.QueryExp;
import javax.management.ObjectName;

import com.sun.enterprise.admin.common.constant.AdminConstants;
import java.util.logging.Level;
import java.util.logging.Logger;


/**
 * This class encapsulates event information that will be useful
 * in devlivering the event, like the target mbean name and 
 * and/or query expression, so that this can be potentially can be delivered 
 * to one than one MBean
 *
 * @author Satish Viswanatham
 * @version 1.0
 */
public class EventKey implements java.io.Serializable {

    static Logger logger = Logger.getLogger(AdminConstants.kLoggerName);

    static final String MALFORMED_OBJECT_NAME = "event.object_name_in_event_is_invalid";

    /**
     * Target object name for event
     */
    private ObjectName objName;

    /**
     * Filter query for event processing
     */
    private QueryExp qry;


    /**
     * public constructor
     */
    public EventKey ( String name, QueryExp q) {
    	try {
           objName = new ObjectName ( name);
           qry = q;
	    } catch( Exception e) {
	        //throw a warning
	        // user need to reset values 
            logger.log(Level.WARNING, MALFORMED_OBJECT_NAME, name);
	    }
    }
    
    /**
     * retuns the ObjectName
     */
    public ObjectName getObjectName() { return objName; }

    /**
     * return query for this event
     *
     * @return QuertExp query object
     */
    public QueryExp   getQuery()         { return qry; }


    /**
     * object name setter
     */
    public void setObjectName(ObjectName obj) { objName = obj; }

    /**
     * query exp setter
     */
    public void setQuery(QueryExp q) { qry = q;}
}
